/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountOptions;
import com.stormpath.sdk.account.AccountStatus;
import com.stormpath.sdk.account.EmailVerificationToken;
import com.stormpath.sdk.directory.CustomData;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupCriteria;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.group.GroupMembership;
import com.stormpath.sdk.group.GroupMembershipList;
import com.stormpath.sdk.impl.directory.AbstractDirectoryEntity;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.group.DefaultGroupMembership;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StatusProperty;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.tenant.Tenant;
import java.util.Map;

public class DefaultAccount
extends AbstractDirectoryEntity
implements Account {
    static final StringProperty EMAIL = new StringProperty("email");
    static final StringProperty USERNAME = new StringProperty("username");
    public static final StringProperty PASSWORD = new StringProperty("password");
    static final StringProperty GIVEN_NAME = new StringProperty("givenName");
    static final StringProperty MIDDLE_NAME = new StringProperty("middleName");
    static final StringProperty SURNAME = new StringProperty("surname");
    static final StatusProperty<AccountStatus> STATUS = new StatusProperty<AccountStatus>(AccountStatus.class);
    static final StringProperty FULL_NAME = new StringProperty("fullName");
    static final ResourceReference<EmailVerificationToken> EMAIL_VERIFICATION_TOKEN = new ResourceReference<EmailVerificationToken>("emailVerificationToken", EmailVerificationToken.class);
    static final ResourceReference<Directory> DIRECTORY = new ResourceReference<Directory>("directory", Directory.class);
    static final ResourceReference<Tenant> TENANT = new ResourceReference<Tenant>("tenant", Tenant.class);
    static final CollectionReference<GroupList, Group> GROUPS = new CollectionReference<GroupList, Group>("groups", GroupList.class, Group.class);
    static final CollectionReference<GroupMembershipList, GroupMembership> GROUP_MEMBERSHIPS = new CollectionReference<GroupMembershipList, GroupMembership>("groupMemberships", GroupMembershipList.class, GroupMembership.class);
    static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultAccount.createPropertyDescriptorMap(USERNAME, EMAIL, PASSWORD, GIVEN_NAME, MIDDLE_NAME, SURNAME, STATUS, FULL_NAME, EMAIL_VERIFICATION_TOKEN, CUSTOM_DATA, DIRECTORY, TENANT, GROUPS, GROUP_MEMBERSHIPS);

    public DefaultAccount(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAccount(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    protected boolean isPrintableProperty(String name) {
        return !PASSWORD.getName().equalsIgnoreCase(name);
    }

    public String getUsername() {
        return this.getString(USERNAME);
    }

    public void setUsername(String username) {
        this.setProperty(USERNAME, (Object)username);
    }

    public String getEmail() {
        return this.getString(EMAIL);
    }

    public void setEmail(String email) {
        this.setProperty(EMAIL, (Object)email);
    }

    public void setPassword(String password) {
        this.setProperty(PASSWORD, (Object)password);
    }

    public String getGivenName() {
        return this.getString(GIVEN_NAME);
    }

    public void setGivenName(String givenName) {
        this.setProperty(GIVEN_NAME, (Object)givenName);
    }

    public String getMiddleName() {
        return this.getString(MIDDLE_NAME);
    }

    public void setMiddleName(String middleName) {
        this.setProperty(MIDDLE_NAME, (Object)middleName);
    }

    public String getSurname() {
        return this.getString(SURNAME);
    }

    public void setSurname(String surname) {
        this.setProperty(SURNAME, (Object)surname);
    }

    public String getFullName() {
        return this.getString(FULL_NAME);
    }

    public AccountStatus getStatus() {
        String value = this.getStringProperty(STATUS.getName());
        if (value == null) {
            return null;
        }
        return AccountStatus.valueOf((String)value.toUpperCase());
    }

    public void setStatus(AccountStatus status) {
        this.setProperty(STATUS, (Object)status.name());
    }

    public GroupList getGroups() {
        return (GroupList)this.getResourceProperty(GROUPS);
    }

    public GroupList getGroups(Map<String, Object> queryParams) {
        GroupList list = this.getGroups();
        return this.getDataStore().getResource(list.getHref(), GroupList.class, queryParams);
    }

    public GroupList getGroups(GroupCriteria criteria) {
        GroupList list = this.getGroups();
        return this.getDataStore().getResource(list.getHref(), GroupList.class, (Criteria)criteria);
    }

    public Directory getDirectory() {
        return this.getResourceProperty(DIRECTORY);
    }

    public Tenant getTenant() {
        return this.getResourceProperty(TENANT);
    }

    public GroupMembershipList getGroupMemberships() {
        return (GroupMembershipList)this.getResourceProperty(GROUP_MEMBERSHIPS);
    }

    public GroupMembership addGroup(Group group) {
        return DefaultGroupMembership.create(this, group, this.getDataStore());
    }

    public EmailVerificationToken getEmailVerificationToken() {
        return this.getResourceProperty(EMAIL_VERIFICATION_TOKEN);
    }

    @Override
    public CustomData getCustomData() {
        return super.getCustomData();
    }

    public void delete() {
        this.getDataStore().delete(this);
    }

    @Override
    public void save() {
        this.applyCustomDataUpdatesIfNecessary();
        super.save();
    }

    public void saveWithResponseOptions(AccountOptions accountOptions) {
        Assert.notNull((Object)accountOptions, (String)"accountOptions can't be null.");
        this.applyCustomDataUpdatesIfNecessary();
        this.getDataStore().save(this, (Options)accountOptions);
    }

    public boolean isMemberOfGroup(String hrefOrName) {
        if (!Strings.hasText((String)hrefOrName)) {
            return false;
        }
        for (Group aGroup : this.getGroups()) {
            if (!aGroup.getName().equalsIgnoreCase(hrefOrName) && !aGroup.getHref().equalsIgnoreCase(hrefOrName)) continue;
            return true;
        }
        return false;
    }
}

