/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.ds;

import com.stormpath.sdk.impl.ds.MapMarshaller;
import com.stormpath.sdk.impl.ds.MarshalingException;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.type.TypeReference;

public class JacksonMapMarshaller
implements MapMarshaller {
    private ObjectMapper objectMapper = new ObjectMapper();
    private boolean prettyPrint = false;

    public JacksonMapMarshaller() {
        this.objectMapper.configure(DeserializationConfig.Feature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isPrettyPrint() {
        return this.objectMapper.getSerializationConfig().isEnabled(SerializationConfig.Feature.INDENT_OUTPUT);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.objectMapper.setSerializationConfig(this.objectMapper.getSerializationConfig().with(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT}));
    }

    @Override
    public String marshal(Map map) {
        try {
            return this.objectMapper.writeValueAsString((Object)map);
        }
        catch (IOException e) {
            throw new MarshalingException("Unable to convert Map to JSON String.", e);
        }
    }

    @Override
    public Map unmarshal(String marshalled) {
        try {
            TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};
            return (Map)this.objectMapper.readValue(marshalled, (TypeReference)typeRef);
        }
        catch (IOException e) {
            throw new MarshalingException("Unable to convert JSON String to Map.", e);
        }
    }
}

