/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.tenant;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.EmailVerificationToken;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.application.ApplicationCriteria;
import com.stormpath.sdk.application.ApplicationList;
import com.stormpath.sdk.application.Applications;
import com.stormpath.sdk.application.CreateApplicationRequest;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.directory.DirectoryCriteria;
import com.stormpath.sdk.directory.DirectoryList;
import com.stormpath.sdk.impl.application.CreateApplicationAndDirectoryRequest;
import com.stormpath.sdk.impl.application.CreateApplicationRequestVisitor;
import com.stormpath.sdk.impl.application.DefaultCreateApplicationRequest;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.tenant.Tenant;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultTenant
extends AbstractInstanceResource
implements Tenant {
    static final StringProperty NAME = new StringProperty("name");
    static final StringProperty KEY = new StringProperty("key");
    static final CollectionReference<ApplicationList, Application> APPLICATIONS = new CollectionReference<ApplicationList, Application>("applications", ApplicationList.class, Application.class);
    static final CollectionReference<DirectoryList, Directory> DIRECTORIES = new CollectionReference<DirectoryList, Directory>("directories", DirectoryList.class, Directory.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultTenant.createPropertyDescriptorMap(NAME, KEY, APPLICATIONS, DIRECTORIES);

    public DefaultTenant(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultTenant(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getName() {
        return this.getString(NAME);
    }

    public String getKey() {
        return this.getString(KEY);
    }

    public Application createApplication(Application application) {
        CreateApplicationRequest request = Applications.newCreateRequestFor((Application)application).build();
        return this.createApplication(request);
    }

    public Application createApplication(CreateApplicationRequest ar) {
        Assert.isInstanceOf(DefaultCreateApplicationRequest.class, (Object)ar);
        DefaultCreateApplicationRequest request = (DefaultCreateApplicationRequest)ar;
        Application application = request.getApplication();
        final String[] href = new String[]{"/" + APPLICATIONS.getName()};
        request.accept(new CreateApplicationRequestVisitor(){

            @Override
            public void visit(DefaultCreateApplicationRequest ignored) {
            }

            @Override
            public void visit(CreateApplicationAndDirectoryRequest request) {
                String name = request.getDirectoryName();
                if (name == null) {
                    name = "true";
                }
                href[0] = href[0] + "?createDirectory=" + name;
            }
        });
        return this.getDataStore().create(href[0], application);
    }

    public ApplicationList getApplications() {
        return (ApplicationList)this.getResourceProperty(APPLICATIONS);
    }

    public ApplicationList getApplications(Map<String, Object> queryParams) {
        ApplicationList proxy = this.getApplications();
        return this.getDataStore().getResource(proxy.getHref(), ApplicationList.class, queryParams);
    }

    public ApplicationList getApplications(ApplicationCriteria criteria) {
        ApplicationList proxy = this.getApplications();
        return this.getDataStore().getResource(proxy.getHref(), ApplicationList.class, (Criteria)criteria);
    }

    public Directory createDirectory(Directory directory) {
        Assert.notNull((Object)directory, (String)"Directory instance cannot be null.");
        return this.getDataStore().create("/" + DIRECTORIES.getName(), directory);
    }

    public DirectoryList getDirectories() {
        return (DirectoryList)this.getResourceProperty(DIRECTORIES);
    }

    public DirectoryList getDirectories(Map<String, Object> queryParams) {
        DirectoryList proxy = this.getDirectories();
        return this.getDataStore().getResource(proxy.getHref(), DirectoryList.class, queryParams);
    }

    public DirectoryList getDirectories(DirectoryCriteria criteria) {
        DirectoryList proxy = this.getDirectories();
        return this.getDataStore().getResource(proxy.getHref(), DirectoryList.class, (Criteria)criteria);
    }

    public Account verifyAccountEmail(String token) {
        String href = "/accounts/emailVerificationTokens/" + token;
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(1);
        props.put("href", href);
        EmailVerificationToken evToken = this.getDataStore().instantiate(EmailVerificationToken.class, props);
        return this.getDataStore().save(evToken, Account.class);
    }
}

