/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.treasury;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.treasury.InboundTransferCollection;
import com.stripe.model.treasury.Transaction;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.treasury.InboundTransferCancelParams;
import com.stripe.param.treasury.InboundTransferCreateParams;
import com.stripe.param.treasury.InboundTransferFailParams;
import com.stripe.param.treasury.InboundTransferListParams;
import com.stripe.param.treasury.InboundTransferRetrieveParams;
import com.stripe.param.treasury.InboundTransferReturnInboundTransferParams;
import com.stripe.param.treasury.InboundTransferSucceedParams;
import java.util.Map;
import lombok.Generated;

public class InboundTransfer
extends ApiResource
implements HasId {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="cancelable")
    Boolean cancelable;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="failure_details")
    FailureDetails failureDetails;
    @SerializedName(value="financial_account")
    String financialAccount;
    @SerializedName(value="hosted_regulatory_receipt_url")
    String hostedRegulatoryReceiptUrl;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="linked_flows")
    LinkedFlows linkedFlows;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="origin_payment_method")
    String originPaymentMethod;
    @SerializedName(value="origin_payment_method_details")
    OriginPaymentMethodDetails originPaymentMethodDetails;
    @SerializedName(value="returned")
    Boolean returned;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="status_transitions")
    StatusTransitions statusTransitions;
    @SerializedName(value="transaction")
    ExpandableField<Transaction> transaction;

    public String getTransaction() {
        return this.transaction != null ? this.transaction.getId() : null;
    }

    public void setTransaction(String id) {
        this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
    }

    public Transaction getTransactionObject() {
        return this.transaction != null ? this.transaction.getExpanded() : null;
    }

    public void setTransactionObject(Transaction expandableObject) {
        this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
    }

    public InboundTransfer cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public InboundTransfer cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public InboundTransfer cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public InboundTransfer cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/treasury/inbound_transfers/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
    }

    public InboundTransfer cancel(InboundTransferCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public InboundTransfer cancel(InboundTransferCancelParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/treasury/inbound_transfers/%s/cancel", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
    }

    public static InboundTransfer create(Map<String, Object> params) throws StripeException {
        return InboundTransfer.create(params, (RequestOptions)null);
    }

    public static InboundTransfer create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/treasury/inbound_transfers");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
    }

    public static InboundTransfer create(InboundTransferCreateParams params) throws StripeException {
        return InboundTransfer.create(params, (RequestOptions)null);
    }

    public static InboundTransfer create(InboundTransferCreateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/treasury/inbound_transfers");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
    }

    public static InboundTransferCollection list(Map<String, Object> params) throws StripeException {
        return InboundTransfer.list(params, (RequestOptions)null);
    }

    public static InboundTransferCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/treasury/inbound_transfers");
        return ApiResource.requestCollection(url, params, InboundTransferCollection.class, options);
    }

    public static InboundTransferCollection list(InboundTransferListParams params) throws StripeException {
        return InboundTransfer.list(params, (RequestOptions)null);
    }

    public static InboundTransferCollection list(InboundTransferListParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, "/v1/treasury/inbound_transfers");
        return ApiResource.requestCollection(url, params, InboundTransferCollection.class, options);
    }

    public static InboundTransfer retrieve(String id) throws StripeException {
        return InboundTransfer.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static InboundTransfer retrieve(String id, RequestOptions options) throws StripeException {
        return InboundTransfer.retrieve(id, (Map<String, Object>)null, options);
    }

    public static InboundTransfer retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/treasury/inbound_transfers/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, InboundTransfer.class, options);
    }

    public static InboundTransfer retrieve(String id, InboundTransferRetrieveParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/treasury/inbound_transfers/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, InboundTransfer.class, options);
    }

    public TestHelpers getTestHelpers() {
        return new TestHelpers(this);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Boolean getCancelable() {
        return this.cancelable;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public FailureDetails getFailureDetails() {
        return this.failureDetails;
    }

    @Generated
    public String getFinancialAccount() {
        return this.financialAccount;
    }

    @Generated
    public String getHostedRegulatoryReceiptUrl() {
        return this.hostedRegulatoryReceiptUrl;
    }

    @Generated
    public LinkedFlows getLinkedFlows() {
        return this.linkedFlows;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getOriginPaymentMethod() {
        return this.originPaymentMethod;
    }

    @Generated
    public OriginPaymentMethodDetails getOriginPaymentMethodDetails() {
        return this.originPaymentMethodDetails;
    }

    @Generated
    public Boolean getReturned() {
        return this.returned;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public StatusTransitions getStatusTransitions() {
        return this.statusTransitions;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCancelable(Boolean cancelable) {
        this.cancelable = cancelable;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setFailureDetails(FailureDetails failureDetails) {
        this.failureDetails = failureDetails;
    }

    @Generated
    public void setFinancialAccount(String financialAccount) {
        this.financialAccount = financialAccount;
    }

    @Generated
    public void setHostedRegulatoryReceiptUrl(String hostedRegulatoryReceiptUrl) {
        this.hostedRegulatoryReceiptUrl = hostedRegulatoryReceiptUrl;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLinkedFlows(LinkedFlows linkedFlows) {
        this.linkedFlows = linkedFlows;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOriginPaymentMethod(String originPaymentMethod) {
        this.originPaymentMethod = originPaymentMethod;
    }

    @Generated
    public void setOriginPaymentMethodDetails(OriginPaymentMethodDetails originPaymentMethodDetails) {
        this.originPaymentMethodDetails = originPaymentMethodDetails;
    }

    @Generated
    public void setReturned(Boolean returned) {
        this.returned = returned;
    }

    @Generated
    public void setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setStatusTransitions(StatusTransitions statusTransitions) {
        this.statusTransitions = statusTransitions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InboundTransfer)) {
            return false;
        }
        InboundTransfer other = (InboundTransfer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Boolean this$cancelable = this.getCancelable();
        Boolean other$cancelable = other.getCancelable();
        if (this$cancelable == null ? other$cancelable != null : !((Object)this$cancelable).equals(other$cancelable)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Boolean this$returned = this.getReturned();
        Boolean other$returned = other.getReturned();
        if (this$returned == null ? other$returned != null : !((Object)this$returned).equals(other$returned)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        FailureDetails this$failureDetails = this.getFailureDetails();
        FailureDetails other$failureDetails = other.getFailureDetails();
        if (this$failureDetails == null ? other$failureDetails != null : !((Object)this$failureDetails).equals(other$failureDetails)) {
            return false;
        }
        String this$financialAccount = this.getFinancialAccount();
        String other$financialAccount = other.getFinancialAccount();
        if (this$financialAccount == null ? other$financialAccount != null : !this$financialAccount.equals(other$financialAccount)) {
            return false;
        }
        String this$hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
        String other$hostedRegulatoryReceiptUrl = other.getHostedRegulatoryReceiptUrl();
        if (this$hostedRegulatoryReceiptUrl == null ? other$hostedRegulatoryReceiptUrl != null : !this$hostedRegulatoryReceiptUrl.equals(other$hostedRegulatoryReceiptUrl)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LinkedFlows this$linkedFlows = this.getLinkedFlows();
        LinkedFlows other$linkedFlows = other.getLinkedFlows();
        if (this$linkedFlows == null ? other$linkedFlows != null : !((Object)this$linkedFlows).equals(other$linkedFlows)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$originPaymentMethod = this.getOriginPaymentMethod();
        String other$originPaymentMethod = other.getOriginPaymentMethod();
        if (this$originPaymentMethod == null ? other$originPaymentMethod != null : !this$originPaymentMethod.equals(other$originPaymentMethod)) {
            return false;
        }
        OriginPaymentMethodDetails this$originPaymentMethodDetails = this.getOriginPaymentMethodDetails();
        OriginPaymentMethodDetails other$originPaymentMethodDetails = other.getOriginPaymentMethodDetails();
        if (this$originPaymentMethodDetails == null ? other$originPaymentMethodDetails != null : !((Object)this$originPaymentMethodDetails).equals(other$originPaymentMethodDetails)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        StatusTransitions this$statusTransitions = this.getStatusTransitions();
        StatusTransitions other$statusTransitions = other.getStatusTransitions();
        if (this$statusTransitions == null ? other$statusTransitions != null : !((Object)this$statusTransitions).equals(other$statusTransitions)) {
            return false;
        }
        String this$transaction = this.getTransaction();
        String other$transaction = other.getTransaction();
        return !(this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InboundTransfer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Boolean $cancelable = this.getCancelable();
        result = result * 59 + ($cancelable == null ? 43 : ((Object)$cancelable).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Boolean $returned = this.getReturned();
        result = result * 59 + ($returned == null ? 43 : ((Object)$returned).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        FailureDetails $failureDetails = this.getFailureDetails();
        result = result * 59 + ($failureDetails == null ? 43 : ((Object)$failureDetails).hashCode());
        String $financialAccount = this.getFinancialAccount();
        result = result * 59 + ($financialAccount == null ? 43 : $financialAccount.hashCode());
        String $hostedRegulatoryReceiptUrl = this.getHostedRegulatoryReceiptUrl();
        result = result * 59 + ($hostedRegulatoryReceiptUrl == null ? 43 : $hostedRegulatoryReceiptUrl.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LinkedFlows $linkedFlows = this.getLinkedFlows();
        result = result * 59 + ($linkedFlows == null ? 43 : ((Object)$linkedFlows).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $originPaymentMethod = this.getOriginPaymentMethod();
        result = result * 59 + ($originPaymentMethod == null ? 43 : $originPaymentMethod.hashCode());
        OriginPaymentMethodDetails $originPaymentMethodDetails = this.getOriginPaymentMethodDetails();
        result = result * 59 + ($originPaymentMethodDetails == null ? 43 : ((Object)$originPaymentMethodDetails).hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        StatusTransitions $statusTransitions = this.getStatusTransitions();
        result = result * 59 + ($statusTransitions == null ? 43 : ((Object)$statusTransitions).hashCode());
        String $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class TestHelpers {
        private final InboundTransfer resource;

        private TestHelpers(InboundTransfer resource) {
            this.resource = resource;
        }

        public InboundTransfer succeed() throws StripeException {
            return this.succeed((Map<String, Object>)null, (RequestOptions)null);
        }

        public InboundTransfer succeed(RequestOptions options) throws StripeException {
            return this.succeed((Map<String, Object>)null, options);
        }

        public InboundTransfer succeed(Map<String, Object> params) throws StripeException {
            return this.succeed(params, (RequestOptions)null);
        }

        public InboundTransfer succeed(Map<String, Object> params, RequestOptions options) throws StripeException {
            String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/test_helpers/treasury/inbound_transfers/%s/succeed", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
        }

        public InboundTransfer succeed(InboundTransferSucceedParams params) throws StripeException {
            return this.succeed(params, (RequestOptions)null);
        }

        public InboundTransfer succeed(InboundTransferSucceedParams params, RequestOptions options) throws StripeException {
            String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/test_helpers/treasury/inbound_transfers/%s/succeed", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
        }

        public InboundTransfer fail() throws StripeException {
            return this.fail((Map<String, Object>)null, (RequestOptions)null);
        }

        public InboundTransfer fail(RequestOptions options) throws StripeException {
            return this.fail((Map<String, Object>)null, options);
        }

        public InboundTransfer fail(Map<String, Object> params) throws StripeException {
            return this.fail(params, (RequestOptions)null);
        }

        public InboundTransfer fail(Map<String, Object> params, RequestOptions options) throws StripeException {
            String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/test_helpers/treasury/inbound_transfers/%s/fail", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
        }

        public InboundTransfer fail(InboundTransferFailParams params) throws StripeException {
            return this.fail(params, (RequestOptions)null);
        }

        public InboundTransfer fail(InboundTransferFailParams params, RequestOptions options) throws StripeException {
            String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/test_helpers/treasury/inbound_transfers/%s/fail", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
        }

        public InboundTransfer returnInboundTransfer() throws StripeException {
            return this.returnInboundTransfer((Map<String, Object>)null, (RequestOptions)null);
        }

        public InboundTransfer returnInboundTransfer(RequestOptions options) throws StripeException {
            return this.returnInboundTransfer((Map<String, Object>)null, options);
        }

        public InboundTransfer returnInboundTransfer(Map<String, Object> params) throws StripeException {
            return this.returnInboundTransfer(params, (RequestOptions)null);
        }

        public InboundTransfer returnInboundTransfer(Map<String, Object> params, RequestOptions options) throws StripeException {
            String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/test_helpers/treasury/inbound_transfers/%s/return", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
        }

        public InboundTransfer returnInboundTransfer(InboundTransferReturnInboundTransferParams params) throws StripeException {
            return this.returnInboundTransfer(params, (RequestOptions)null);
        }

        public InboundTransfer returnInboundTransfer(InboundTransferReturnInboundTransferParams params, RequestOptions options) throws StripeException {
            String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/test_helpers/treasury/inbound_transfers/%s/return", ApiResource.urlEncodeId(this.resource.getId())));
            return ApiResource.request(ApiResource.RequestMethod.POST, url, params, InboundTransfer.class, options);
        }
    }

    public static class FailureDetails
    extends StripeObject {
        @SerializedName(value="code")
        String code;

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public void setCode(String code) {
            this.code = code;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FailureDetails)) {
                return false;
            }
            FailureDetails other = (FailureDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            return !(this$code == null ? other$code != null : !this$code.equals(other$code));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FailureDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            return result;
        }
    }

    public static class LinkedFlows
    extends StripeObject {
        @SerializedName(value="received_debit")
        String receivedDebit;

        @Generated
        public String getReceivedDebit() {
            return this.receivedDebit;
        }

        @Generated
        public void setReceivedDebit(String receivedDebit) {
            this.receivedDebit = receivedDebit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LinkedFlows)) {
                return false;
            }
            LinkedFlows other = (LinkedFlows)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$receivedDebit = this.getReceivedDebit();
            String other$receivedDebit = other.getReceivedDebit();
            return !(this$receivedDebit == null ? other$receivedDebit != null : !this$receivedDebit.equals(other$receivedDebit));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LinkedFlows;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $receivedDebit = this.getReceivedDebit();
            result = result * 59 + ($receivedDebit == null ? 43 : $receivedDebit.hashCode());
            return result;
        }
    }

    public static class OriginPaymentMethodDetails
    extends StripeObject {
        @SerializedName(value="billing_details")
        BillingDetails billingDetails;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;

        @Generated
        public BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public void setBillingDetails(BillingDetails billingDetails) {
            this.billingDetails = billingDetails;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUsBankAccount(UsBankAccount usBankAccount) {
            this.usBankAccount = usBankAccount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OriginPaymentMethodDetails)) {
                return false;
            }
            OriginPaymentMethodDetails other = (OriginPaymentMethodDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BillingDetails this$billingDetails = this.getBillingDetails();
            BillingDetails other$billingDetails = other.getBillingDetails();
            if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            return !(this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OriginPaymentMethodDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BillingDetails $billingDetails = this.getBillingDetails();
            result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            return result;
        }

        public static class BillingDetails
        extends StripeObject {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="email")
            String email;
            @SerializedName(value="name")
            String name;

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public String getEmail() {
                return this.email;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public void setAddress(Address address) {
                this.address = address;
            }

            @Generated
            public void setEmail(String email) {
                this.email = email;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillingDetails)) {
                    return false;
                }
                BillingDetails other = (BillingDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Address this$address = this.getAddress();
                Address other$address = other.getAddress();
                if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                    return false;
                }
                String this$email = this.getEmail();
                String other$email = other.getEmail();
                if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillingDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Address $address = this.getAddress();
                result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
                String $email = this.getEmail();
                result = result * 59 + ($email == null ? 43 : $email.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }
        }

        public static class UsBankAccount
        extends StripeObject {
            @SerializedName(value="account_holder_type")
            String accountHolderType;
            @SerializedName(value="account_type")
            String accountType;
            @SerializedName(value="bank_name")
            String bankName;
            @SerializedName(value="fingerprint")
            String fingerprint;
            @SerializedName(value="last4")
            String last4;
            @SerializedName(value="network")
            String network;
            @SerializedName(value="routing_number")
            String routingNumber;

            @Generated
            public String getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public String getAccountType() {
                return this.accountType;
            }

            @Generated
            public String getBankName() {
                return this.bankName;
            }

            @Generated
            public String getFingerprint() {
                return this.fingerprint;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public String getNetwork() {
                return this.network;
            }

            @Generated
            public String getRoutingNumber() {
                return this.routingNumber;
            }

            @Generated
            public void setAccountHolderType(String accountHolderType) {
                this.accountHolderType = accountHolderType;
            }

            @Generated
            public void setAccountType(String accountType) {
                this.accountType = accountType;
            }

            @Generated
            public void setBankName(String bankName) {
                this.bankName = bankName;
            }

            @Generated
            public void setFingerprint(String fingerprint) {
                this.fingerprint = fingerprint;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public void setNetwork(String network) {
                this.network = network;
            }

            @Generated
            public void setRoutingNumber(String routingNumber) {
                this.routingNumber = routingNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountHolderType = this.getAccountHolderType();
                String other$accountHolderType = other.getAccountHolderType();
                if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                    return false;
                }
                String this$accountType = this.getAccountType();
                String other$accountType = other.getAccountType();
                if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
                    return false;
                }
                String this$bankName = this.getBankName();
                String other$bankName = other.getBankName();
                if (this$bankName == null ? other$bankName != null : !this$bankName.equals(other$bankName)) {
                    return false;
                }
                String this$fingerprint = this.getFingerprint();
                String other$fingerprint = other.getFingerprint();
                if (this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                if (this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4)) {
                    return false;
                }
                String this$network = this.getNetwork();
                String other$network = other.getNetwork();
                if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                    return false;
                }
                String this$routingNumber = this.getRoutingNumber();
                String other$routingNumber = other.getRoutingNumber();
                return !(this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountHolderType = this.getAccountHolderType();
                result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
                String $accountType = this.getAccountType();
                result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
                String $bankName = this.getBankName();
                result = result * 59 + ($bankName == null ? 43 : $bankName.hashCode());
                String $fingerprint = this.getFingerprint();
                result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                String $network = this.getNetwork();
                result = result * 59 + ($network == null ? 43 : $network.hashCode());
                String $routingNumber = this.getRoutingNumber();
                result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                return result;
            }
        }
    }

    public static class StatusTransitions
    extends StripeObject {
        @SerializedName(value="canceled_at")
        Long canceledAt;
        @SerializedName(value="failed_at")
        Long failedAt;
        @SerializedName(value="succeeded_at")
        Long succeededAt;

        @Generated
        public Long getCanceledAt() {
            return this.canceledAt;
        }

        @Generated
        public Long getFailedAt() {
            return this.failedAt;
        }

        @Generated
        public Long getSucceededAt() {
            return this.succeededAt;
        }

        @Generated
        public void setCanceledAt(Long canceledAt) {
            this.canceledAt = canceledAt;
        }

        @Generated
        public void setFailedAt(Long failedAt) {
            this.failedAt = failedAt;
        }

        @Generated
        public void setSucceededAt(Long succeededAt) {
            this.succeededAt = succeededAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatusTransitions)) {
                return false;
            }
            StatusTransitions other = (StatusTransitions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$canceledAt = this.getCanceledAt();
            Long other$canceledAt = other.getCanceledAt();
            if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
                return false;
            }
            Long this$failedAt = this.getFailedAt();
            Long other$failedAt = other.getFailedAt();
            if (this$failedAt == null ? other$failedAt != null : !((Object)this$failedAt).equals(other$failedAt)) {
                return false;
            }
            Long this$succeededAt = this.getSucceededAt();
            Long other$succeededAt = other.getSucceededAt();
            return !(this$succeededAt == null ? other$succeededAt != null : !((Object)this$succeededAt).equals(other$succeededAt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StatusTransitions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $canceledAt = this.getCanceledAt();
            result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
            Long $failedAt = this.getFailedAt();
            result = result * 59 + ($failedAt == null ? 43 : ((Object)$failedAt).hashCode());
            Long $succeededAt = this.getSucceededAt();
            result = result * 59 + ($succeededAt == null ? 43 : ((Object)$succeededAt).hashCode());
            return result;
        }
    }
}

