package com.sun.xml.bind.v2.model.nav;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;

/**
 * Implementation of GenericArrayType interface for core reflection.
 */
final class GenericArrayTypeImpl implements GenericArrayType {
    private Type genericComponentType;

    GenericArrayTypeImpl(Type ct) {
        assert ct!=null;
        genericComponentType = ct;
    }

    /**
     * Returns  a <tt>Type</tt> object representing the component type
     * of this array.
     *
     * @return a <tt>Type</tt> object representing the component type
     *         of this array
     * @since 1.5
     */
    public Type getGenericComponentType() {
        return genericComponentType; // return cached component type
    }

    public String toString() {
        Type componentType = getGenericComponentType();
        StringBuilder sb = new StringBuilder();

        if (componentType instanceof Class)
            sb.append(((Class) componentType).getName());
        else
            sb.append(componentType.toString());
        sb.append("[]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof GenericArrayType) {
            GenericArrayType that = (GenericArrayType) o;

            Type thatComponentType = that.getGenericComponentType();
            return genericComponentType.equals(thatComponentType);
        } else
            return false;
    }

    @Override
    public int hashCode() {
        return genericComponentType.hashCode();
    }
}
