/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api;

import com.suning.api.exception.SuningApiException;
import com.suning.api.util.IOUtil;
import com.suning.api.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponse {
    private HttpURLConnection con;
    private InputStream in;

    public HttpResponse(HttpURLConnection con) throws IOException {
        if (null != con) {
            this.con = con;
            this.in = con.getInputStream();
            String contentEncoding = con.getContentEncoding();
            if (!StringUtil.isEmpty(contentEncoding) && contentEncoding.contains("gzip")) {
                this.in = new GZIPInputStream(this.in);
            }
        }
    }

    public void close() throws SuningApiException {
        IOUtil.closeQuietly(this.in);
        if (null != this.con) {
            this.con.disconnect();
        }
    }

    public String getResponseHeader(String name) {
        return this.con.getHeaderField(name);
    }

    public Map<String, List<String>> getResponseHeaderFields() {
        return this.con.getHeaderFields();
    }

    public HttpURLConnection getCon() {
        return this.con;
    }

    public void setCon(HttpURLConnection con) {
        this.con = con;
    }

    public InputStream getIn() {
        return this.in;
    }

    public void setIn(InputStream in) {
        this.in = in;
    }
}

