/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.link.io.netty.handler.codec.http.websocketx;

import com.suning.api.link.io.netty.channel.ChannelFuture;
import com.suning.api.link.io.netty.channel.ChannelFutureListener;
import com.suning.api.link.io.netty.channel.ChannelHandlerContext;
import com.suning.api.link.io.netty.channel.ChannelInboundHandlerAdapter;
import com.suning.api.link.io.netty.channel.ChannelPipeline;
import com.suning.api.link.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.suning.api.link.io.netty.handler.codec.http.FullHttpRequest;
import com.suning.api.link.io.netty.handler.codec.http.HttpHeaders;
import com.suning.api.link.io.netty.handler.codec.http.HttpMethod;
import com.suning.api.link.io.netty.handler.codec.http.HttpRequest;
import com.suning.api.link.io.netty.handler.codec.http.HttpResponse;
import com.suning.api.link.io.netty.handler.codec.http.HttpResponseStatus;
import com.suning.api.link.io.netty.handler.codec.http.HttpVersion;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;

class WebSocketServerProtocolHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final String websocketPath;
    private final String subprotocols;
    private final boolean allowExtensions;
    private final int maxFramePayloadSize;

    WebSocketServerProtocolHandshakeHandler(String websocketPath, String subprotocols, boolean allowExtensions, int maxFrameSize) {
        this.websocketPath = websocketPath;
        this.subprotocols = subprotocols;
        this.allowExtensions = allowExtensions;
        this.maxFramePayloadSize = maxFrameSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpRequest req;
        block6: {
            block5: {
                req = (FullHttpRequest)msg;
                try {
                    if (req.getMethod() != HttpMethod.GET) {
                        WebSocketServerProtocolHandshakeHandler.sendHttpResponse(ctx, req, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
                        Object var8_4 = null;
                        break block5;
                    }
                    WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(WebSocketServerProtocolHandshakeHandler.getWebSocketLocation(ctx.pipeline(), req, this.websocketPath), this.subprotocols, this.allowExtensions, this.maxFramePayloadSize);
                    WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(req);
                    if (handshaker == null) {
                        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(ctx.channel());
                        break block6;
                    } else {
                        ChannelFuture handshakeFuture = handshaker.handshake(ctx.channel(), req);
                        handshakeFuture.addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (!future.isSuccess()) {
                                    ctx.fireExceptionCaught(future.cause());
                                } else {
                                    ctx.fireUserEventTriggered((Object)WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE);
                                }
                            }
                        });
                        WebSocketServerProtocolHandler.setHandshaker(ctx, handshaker);
                        ctx.pipeline().replace(this, "WS403Responder", WebSocketServerProtocolHandler.forbiddenHttpRequestResponder());
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    req.release();
                    throw throwable;
                }
            }
            req.release();
            return;
        }
        Object var8_5 = null;
        req.release();
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        ChannelFuture f = ctx.channel().writeAndFlush(res);
        if (!HttpHeaders.isKeepAlive(req) || res.getStatus().code() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private static String getWebSocketLocation(ChannelPipeline cp, HttpRequest req, String path) {
        String protocol = "ws";
        return protocol + "://" + req.headers().get("Host") + path;
    }
}

