/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api;

import com.suning.api.AbstractHttpClient;
import com.suning.api.SuningMultiPartRequest;
import com.suning.api.SuningRequest;
import com.suning.api.SuningResponse;
import com.suning.api.config.Configuration;
import com.suning.api.exception.SuningApiCheckException;
import com.suning.api.exception.SuningApiException;
import com.suning.api.parse.Parse;
import com.suning.api.parse.ParseFactory;
import com.suning.api.util.CheckUtil;
import com.suning.api.util.SecurityUtil;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSuningClient
extends AbstractHttpClient {
    private String serverUrl = "http://openpre.cnsuning.com/api/http/sopRequest";
    private String accessToken;
    private String appKey;
    private String appSecret;
    private String format = "json";
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private String proxyHost;
    private int proxyPort;

    public DefaultSuningClient(String serverUrl, String appKey, String appSecret) {
        this.serverUrl = serverUrl;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public DefaultSuningClient(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public DefaultSuningClient(String serverUrl, String appKey, String appSecret, String format) {
        this.serverUrl = serverUrl;
        this.appKey = appKey;
        this.format = format;
        this.appSecret = appSecret;
    }

    public DefaultSuningClient(String serverUrl, String appKey, String appSecret, String accessToken, String format) {
        this(serverUrl, appKey, appSecret, format);
        this.appSecret = appSecret;
        this.accessToken = accessToken;
    }

    public DefaultSuningClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, appKey, appSecret, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultSuningClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String proxyHost, int proxyPort) {
        this(serverUrl, appKey, appSecret, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public DefaultSuningClient(String serverUrl, String appKey, String appSecret, String accessToken, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, appKey, appSecret, accessToken, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultSuningClient(String serverUrl, String appKey, String appSecret, String accessToken, String format, int connectTimeout, int readTimeout, String proxyHost, int proxyPort) {
        this(serverUrl, appKey, appSecret, accessToken, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    @Override
    public <T extends SuningResponse> T excute(SuningRequest<T> paramSuningRequest) throws SuningApiException {
        if (null == paramSuningRequest) {
            throw new SuningApiException("param paramSuningRequest is null");
        }
        Map<String, String> sysParams = paramSuningRequest.getSysParams();
        sysParams.put("appKey", this.appKey);
        sysParams.put("access_token", this.accessToken);
        sysParams.put("versionNo", "v1.2");
        sysParams.put("appRequestTime", paramSuningRequest.getAppRequestTime());
        sysParams.put("format", this.format);
        this.dealUpload(paramSuningRequest);
        String resParams = paramSuningRequest.getResParams();
        try {
            CheckUtil.checkApiParam(paramSuningRequest, this.format);
        }
        catch (SuningApiCheckException e) {
            T rspObj = CheckUtil.constructErrorResponse(paramSuningRequest, e.getMessage(), this.format);
            sysParams.put("resparams", resParams);
            ((SuningResponse)rspObj).setSysParams(sysParams);
            return rspObj;
        }
        Configuration config = new Configuration();
        config.setConnectUrl(this.serverUrl);
        config.setHttpConnectionTimeout(this.connectTimeout);
        config.setHttpReadTimeout(this.readTimeout);
        config.setProxyHost(this.proxyHost);
        config.setProxyPort(this.proxyPort);
        String signInfo = SecurityUtil.dataSign(paramSuningRequest, resParams, this.appKey, this.appSecret);
        sysParams.put("signInfo", signInfo);
        config.setReqHeaders(sysParams);
        String responseData = this.execute(config, resParams);
        Parse parse = ParseFactory.getParse(this.format);
        T rspObj = parse.parseToResponse(responseData, paramSuningRequest.getResponseClass());
        ((SuningResponse)rspObj).setBody(responseData);
        ((SuningResponse)rspObj).setReqParam(resParams);
        ((SuningResponse)rspObj).setSysParams(sysParams);
        return rspObj;
    }

    public <T extends SuningResponse> T excuteMultiPart(SuningMultiPartRequest<T> multiPartRequest) throws SuningApiException {
        if (null == multiPartRequest) {
            throw new SuningApiException("param paramSuningRequest is null");
        }
        Map<String, String> sysParams = multiPartRequest.getSysParams();
        sysParams.put("appKey", this.appKey);
        sysParams.put("access_token", this.accessToken);
        sysParams.put("versionNo", "v1.2");
        sysParams.put("appRequestTime", multiPartRequest.getAppRequestTime());
        sysParams.put("format", this.format);
        String responseData = null;
        sysParams.put("appSecret", this.appSecret);
        try {
            URL apiConURL = new URL(this.serverUrl);
            HttpURLConnection con = (HttpURLConnection)apiConURL.openConnection();
            multiPartRequest.setMultiPartParams(con, sysParams);
            responseData = multiPartRequest.getMultiPartReqContent(con);
        }
        catch (Exception e) {
            throw new SuningApiException(e);
        }
        Parse parse = ParseFactory.getParse(this.format);
        Object rspObj = parse.parseToResponse(responseData, multiPartRequest.getResponseClass());
        ((SuningResponse)rspObj).setBody(responseData);
        ((SuningResponse)rspObj).setSysParams(sysParams);
        return rspObj;
    }
}

