/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api;

import com.suning.api.SuningRequest;
import com.suning.api.SuningResponse;
import com.suning.api.exception.SuningApiException;
import com.suning.api.util.SecurityUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SuningMultiPartRequest<T extends SuningResponse>
extends SuningRequest {
    public abstract Map<String, String> getTextData();

    public abstract Map<String, byte[]> getFileData();

    protected void setMultiPartParams(HttpURLConnection con, Map<String, String> sysParams) throws SuningApiException, IOException {
        Map<String, String> textData = this.getTextData();
        Map<String, byte[]> fileData = this.getFileData();
        String boundary = String.valueOf(System.nanoTime());
        String cType = "multipart/form-data;charset=utf-8;boundary=" + boundary;
        this.setMultiPartSystemParams(con, sysParams, cType);
        OutputStream out = con.getOutputStream();
        byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes("utf-8");
        if (textData != null) {
            Set<Map.Entry<String, String>> textEntrySet = textData.entrySet();
            for (Map.Entry<String, String> entry : textEntrySet) {
                byte[] textBytes = this.getTextEntry(entry.getKey(), entry.getValue(), "utf-8");
                out.write(entryBoundaryBytes);
                out.write(textBytes);
            }
        }
        Set<Map.Entry<String, byte[]>> fileEntrySet = fileData.entrySet();
        for (Map.Entry<String, String> entry : fileEntrySet) {
            if (entry.getValue() == null) continue;
            byte[] fileBytes = this.getFileEntry(entry.getKey(), "test", "application/octet-stream", "utf-8");
            out.write(entryBoundaryBytes);
            out.write(fileBytes);
            out.write((byte[])entry.getValue());
        }
        byte[] endBoundaryBytes = ("\r\n--" + boundary + "--\r\n").getBytes("utf-8");
        out.write(endBoundaryBytes);
        out.flush();
        out.close();
    }

    protected String getMultiPartReqContent(HttpURLConnection con) throws IOException {
        BufferedReader inr = new BufferedReader(new InputStreamReader(con.getInputStream()));
        String inputLine = null;
        StringBuilder sbl = new StringBuilder();
        while ((inputLine = inr.readLine()) != null) {
            sbl.append(inputLine);
        }
        inr.close();
        return sbl.toString();
    }

    private void setMultiPartSystemParams(HttpURLConnection con, Map<String, String> sysParams, String cType) throws SuningApiException, ProtocolException {
        String appKeyStr = sysParams.get("appKey");
        String appMethodStr = sysParams.get("appMethod");
        String formatStr = sysParams.get("format");
        String versionNoStr = sysParams.get("versionNo");
        String appRequestTimeStr = sysParams.get("appRequestTime");
        String appSecretStr = sysParams.get("appSecret");
        String accessTokenStr = sysParams.get("access_token");
        con.setRequestProperty("Content-type", cType);
        con.setRequestMethod("POST");
        con.setReadTimeout(30000);
        con.setConnectTimeout(30000);
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("appKey", appKeyStr);
        con.setRequestProperty("appMethod", appMethodStr);
        con.setRequestProperty("format", formatStr);
        con.setRequestProperty("versionNo", versionNoStr);
        con.setRequestProperty("appRequestTime", appRequestTimeStr);
        con.setRequestProperty("signInfo", SecurityUtil.dataSimpleSign(appSecretStr, appMethodStr, appRequestTimeStr, appKeyStr, versionNoStr));
        if (accessTokenStr != null && accessTokenStr.length() > 0) {
            con.setRequestProperty("access_token", accessTokenStr);
        }
    }

    private byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }
}

