/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api;

import com.suning.api.SuningResponse;
import com.suning.api.annotation.ApiNoneParsedField;
import com.suning.api.exception.SuningApiException;
import com.suning.api.util.JsonUtil;
import com.suning.api.util.StringUtil;
import com.suning.api.util.XmlUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SuningRequest<T extends SuningResponse> {
    @ApiNoneParsedField
    protected String appRequestTime;
    @ApiNoneParsedField
    protected String appMethod;
    @ApiNoneParsedField
    protected String signInfo;
    @ApiNoneParsedField
    protected String reqFormat = "json";
    @ApiNoneParsedField
    protected String resparamsInputType;
    @ApiNoneParsedField
    protected boolean checkParam = false;
    @ApiNoneParsedField
    protected Map<?, ?> resParamsMap;
    @ApiNoneParsedField
    protected String resparams;

    public abstract String getApiMethdeName();

    public abstract Class<T> getResponseClass();

    public abstract String getBizName();

    public Map<String, String> getSysParams() {
        HashMap<String, String> sysParams = new HashMap<String, String>();
        sysParams.put("appRequestTime", this.getAppRequestTime());
        sysParams.put("appMethod", this.getApiMethdeName());
        sysParams.put("signInfo", this.signInfo);
        return sysParams;
    }

    public String getAppRequestTime() {
        if (StringUtil.isEmpty(this.appRequestTime)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            this.appRequestTime = sdf.format(new Date());
        }
        return this.appRequestTime;
    }

    public void setAppRequestTime(String appRequestTime) {
        this.appRequestTime = appRequestTime;
    }

    public String getAppMethod() {
        return this.appMethod;
    }

    public void setAppMethod(String appMethod) {
        this.appMethod = appMethod;
    }

    public String getSignInfo() {
        return this.signInfo;
    }

    public void setSignInfo(String signInfo) {
        this.signInfo = signInfo;
    }

    public String getReqFormat() {
        return this.reqFormat;
    }

    public void setReqFormat(String reqFormat) {
        this.reqFormat = reqFormat;
    }

    public void setResparams(String resparams) {
        this.resparams = resparams;
    }

    public void setResParamsMap(Map<?, ?> resParamsMap) {
        this.resParamsMap = resParamsMap;
    }

    public Map<?, ?> getResParamsMap() {
        return this.resParamsMap;
    }

    public String getResparamsInputType() {
        if (StringUtil.isEmpty(this.resparamsInputType)) {
            this.resparamsInputType = "bean";
        }
        return this.resparamsInputType.trim();
    }

    public void setResparamsInputType(String resparamsInputType) {
        this.resparamsInputType = resparamsInputType;
    }

    public boolean isCheckParam() {
        return this.checkParam;
    }

    public void setCheckParam(boolean checkParam) {
        this.checkParam = checkParam;
    }

    public String getResParams() throws SuningApiException {
        if (!StringUtil.isEmpty(this.getResparamsInputType())) {
            if (!StringUtil.isEmpty(this.reqFormat) && "json".equalsIgnoreCase(this.reqFormat.trim())) {
                if ("bean".equalsIgnoreCase(this.resparamsInputType)) {
                    this.resparams = JsonUtil.objectToJson(this.getBizName(), this);
                } else if ("map".equalsIgnoreCase(this.resparamsInputType) && null != this.resParamsMap) {
                    this.resparams = JsonUtil.mapToJson(this.resParamsMap);
                }
            } else if ("bean".equalsIgnoreCase(this.resparamsInputType)) {
                this.resparams = XmlUtil.toXml(this);
            } else if ("map".equalsIgnoreCase(this.resparamsInputType) && null != this.resParamsMap) {
                this.resparams = XmlUtil.paseMapToXml(this.resParamsMap);
            }
        }
        return this.resparams;
    }
}

