/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.link.io.netty.handler.codec.http.websocketx;

import com.suning.api.link.io.netty.buffer.ByteBuf;
import com.suning.api.link.io.netty.channel.ChannelHandlerContext;
import com.suning.api.link.io.netty.handler.codec.MessageToMessageEncoder;
import com.suning.api.link.io.netty.handler.codec.TooLongFrameException;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.suning.api.link.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.suning.api.link.io.netty.util.ReferenceCounted;
import com.suning.api.link.io.netty.util.internal.logging.InternalLogger;
import com.suning.api.link.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocket08FrameEncoder
extends MessageToMessageEncoder<WebSocketFrame>
implements WebSocketFrameEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket08FrameEncoder.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private static final int GATHERING_WRITE_TRESHOLD = 1024;
    private final boolean maskPayload;

    public WebSocket08FrameEncoder(boolean maskPayload) {
        this.maskPayload = maskPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        int opcode;
        ByteBuf data = msg.content();
        if (msg instanceof TextWebSocketFrame) {
            opcode = 1;
        } else if (msg instanceof PingWebSocketFrame) {
            opcode = 9;
        } else if (msg instanceof PongWebSocketFrame) {
            opcode = 10;
        } else if (msg instanceof CloseWebSocketFrame) {
            opcode = 8;
        } else if (msg instanceof BinaryWebSocketFrame) {
            opcode = 2;
        } else {
            if (!(msg instanceof ContinuationWebSocketFrame)) throw new UnsupportedOperationException("Cannot encode frame of type: " + msg.getClass().getName());
            opcode = 0;
        }
        int length = data.readableBytes();
        if (logger.isDebugEnabled()) {
            logger.debug("Encoding WebSocket Frame opCode=" + opcode + " length=" + length);
        }
        int b0 = 0;
        if (msg.isFinalFragment()) {
            b0 |= 0x80;
        }
        b0 |= msg.rsv() % 8 << 4;
        b0 |= opcode % 128;
        if (opcode == 9 && length > 125) {
            throw new TooLongFrameException("invalid payload for PING (payload length must be <= 125, was " + length);
        }
        boolean release = true;
        ReferenceCounted buf = null;
        try {
            int size;
            int maskLength;
            int n = maskLength = this.maskPayload ? 4 : 0;
            if (length <= 125) {
                size = 2 + maskLength;
                if (this.maskPayload || length <= 1024) {
                    size += length;
                }
                buf = ctx.alloc().buffer(size);
                ((ByteBuf)buf).writeByte(b0);
                byte b = this.maskPayload ? (byte)(0x80 | (byte)length) : (byte)length;
                ((ByteBuf)buf).writeByte(b);
            } else if (length <= 65535) {
                size = 4 + maskLength;
                if (this.maskPayload || length <= 1024) {
                    size += length;
                }
                buf = ctx.alloc().buffer(size);
                ((ByteBuf)buf).writeByte(b0);
                ((ByteBuf)buf).writeByte(this.maskPayload ? 254 : 126);
                ((ByteBuf)buf).writeByte(length >>> 8 & 0xFF);
                ((ByteBuf)buf).writeByte(length & 0xFF);
            } else {
                size = 10 + maskLength;
                if (this.maskPayload || length <= 1024) {
                    size += length;
                }
                buf = ctx.alloc().buffer(size);
                ((ByteBuf)buf).writeByte(b0);
                ((ByteBuf)buf).writeByte(this.maskPayload ? 255 : 127);
                ((ByteBuf)buf).writeLong(length);
            }
            if (this.maskPayload) {
                int random = (int)(Math.random() * 2.147483647E9);
                byte[] mask = ByteBuffer.allocate(4).putInt(random).array();
                ((ByteBuf)buf).writeBytes(mask);
                ByteOrder srcOrder = data.order();
                ByteOrder dstOrder = ((ByteBuf)buf).order();
                int counter = 0;
                int i = data.readerIndex();
                int end = data.writerIndex();
                if (srcOrder == dstOrder) {
                    int intMask = (mask[0] & 0xFF) << 24 | (mask[1] & 0xFF) << 16 | (mask[2] & 0xFF) << 8 | mask[3] & 0xFF;
                    if (srcOrder == ByteOrder.LITTLE_ENDIAN) {
                        intMask = Integer.reverseBytes(intMask);
                    }
                    while (i + 3 < end) {
                        int intData = data.getInt(i);
                        ((ByteBuf)buf).writeInt(intData ^ intMask);
                        i += 4;
                    }
                }
                while (i < end) {
                    byte byteData = data.getByte(i);
                    ((ByteBuf)buf).writeByte(byteData ^ mask[counter++ % 4]);
                    ++i;
                }
                out.add(buf);
            } else if (((ByteBuf)buf).writableBytes() >= data.readableBytes()) {
                ((ByteBuf)buf).writeBytes(data);
                out.add(buf);
            } else {
                out.add(buf);
                out.add(data.retain());
            }
            release = false;
            Object var21_21 = null;
            if (!release) return;
            if (buf == null) return;
        }
        catch (Throwable throwable) {
            Object var21_22 = null;
            if (!release || buf == null) throw throwable;
            buf.release();
            throw throwable;
        }
        buf.release();
    }
}

