/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.message;

import com.suning.api.message.MessageType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public class Message {
    private String messageId;
    private String source;
    private String topic;
    private String user;
    private String appKey;
    private String createTime;
    private String msg;
    private String sendTime;
    private String recevieTime;
    private MessageType messageType;

    public Message() {
        this.messageId = UUID.randomUUID().toString().replaceAll("-", "");
        this.createTime = this.dateTimeString(new Date());
        this.messageType = MessageType.FROM;
    }

    public Message(MessageType messageType) {
        this.messageType = messageType;
    }

    public Message(String topic, MessageType messageType) {
        this.messageType = messageType;
        this.topic = topic;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(String sendTime) {
        this.sendTime = sendTime;
    }

    public void setSendDateTime(Date sendTime) {
        this.sendTime = this.dateTimeString(sendTime);
    }

    public String getRecevieTime() {
        return this.recevieTime;
    }

    public void setRecevieTime(String recevieTime) {
        this.recevieTime = recevieTime;
    }

    public void setRecevieDateTime(Date recevieTime) {
        this.recevieTime = this.dateTimeString(recevieTime);
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    private String dateTimeString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public String toString() {
        String msgString = null;
        msgString = this.messageType == MessageType.ACK || this.messageType == MessageType.AUTH || this.messageType == MessageType.AUTHACK ? String.format("{msg=%s,messageType=%s}", new Object[]{this.messageId, this.messageType}) : String.format("{messageId=%s ,source=%s,topic=%s,msg=%s,messageType=%s,user=%s,appKey=%s}", new Object[]{this.messageId, this.source, this.topic, this.msg, this.messageType, this.user, this.appKey});
        return msgString;
    }
}

