/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.util;

import com.suning.api.HttpResponse;
import com.suning.api.config.Configuration;
import com.suning.api.exception.SuningApiException;
import com.suning.api.util.IOUtil;
import com.suning.api.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtil {
    public static String doPost(Configuration config, InputStream reqInputStream, String path, byte[] data) throws SuningApiException {
        HttpResponse response = HttpUtil.doPost(config, path, data, reqInputStream);
        if (response != null) {
            String responseData = null;
            responseData = HttpUtil.getResponseAsString(response);
            response.close();
            return responseData;
        }
        return null;
    }

    private static String getResponseAsString(HttpResponse response) throws SuningApiException {
        HttpURLConnection conn = response.getCon();
        String charset = HttpUtil.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return HttpUtil.getStreamAsString(response.getIn(), charset);
        }
        String msg = HttpUtil.getStreamAsString(es, charset);
        if (StringUtil.isEmpty(msg)) {
            try {
                throw new SuningApiException(conn.getResponseCode() + ":" + conn.getResponseMessage());
            }
            catch (IOException e) {
                throw new SuningApiException(e);
            }
        }
        throw new SuningApiException(msg);
    }

    private static String getResponseCharset(String ctype) {
        String charset = "UTF-8";
        if (!StringUtil.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!param.trim().startsWith("charset")) continue;
                String[] pair = param.trim().split("=", 2);
                if (pair.length != 2 || StringUtil.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    private static String getStreamAsString(InputStream stream, String charset) throws SuningApiException {
        String string;
        BufferedReader reader = null;
        try {
            String str;
            reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            string = str = writer.toString();
            Object var9_9 = null;
        }
        catch (IOException e) {
            try {
                throw new SuningApiException(e);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                IOUtil.closeQuietly(reader);
                IOUtil.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(reader);
        IOUtil.closeQuietly(stream);
        return string;
    }

    private static HttpResponse doPost(Configuration config, String path, byte[] data, InputStream reqInputStream) throws SuningApiException {
        int retry = config.getHttpConnectRetryTimes() + 1;
        HttpResponse response = null;
        for (int retryTimes = 1; retryTimes <= retry; ++retryTimes) {
            OutputStream out;
            block15: {
                HttpResponse httpResponse;
                Object var12_11;
                HttpURLConnection con = null;
                out = null;
                try {
                    con = HttpUtil.prePost(config);
                    out = con.getOutputStream();
                    HttpUtil.writeHttpStream(out, reqInputStream, path, data);
                    int responseCode = con.getResponseCode();
                    if (200 == responseCode) {
                        response = new HttpResponse(con);
                    } else {
                        if (400 == responseCode) {
                            throw new SuningApiException(con.getHeaderFields().get(null).get(0));
                        }
                        if (403 == responseCode) {
                            if (retryTimes == config.getHttpConnectRetryTimes()) {
                                response = new HttpResponse(con);
                            }
                            try {
                                Thread.sleep(config.getHttpConnectRetryInterval() * 1000);
                            }
                            catch (InterruptedException e) {
                                con.disconnect();
                                throw new SuningApiException(e);
                            }
                            var12_11 = null;
                            break block15;
                        }
                        if (404 == responseCode) {
                            throw new SuningApiException(con.getHeaderFields().get(null).get(0));
                        }
                        if (500 == responseCode) {
                            throw new SuningApiException(con.getHeaderFields().get(null).get(0));
                        }
                    }
                    httpResponse = response;
                }
                catch (IOException e) {
                    try {
                        if (null != con) {
                            con.disconnect();
                        }
                        throw new SuningApiException(e);
                    }
                    catch (Throwable throwable) {
                        var12_11 = null;
                        IOUtil.closeQuietly(out);
                        IOUtil.closeQuietly(reqInputStream);
                        throw throwable;
                    }
                }
                var12_11 = null;
                IOUtil.closeQuietly(out);
                IOUtil.closeQuietly(reqInputStream);
                return httpResponse;
            }
            IOUtil.closeQuietly(out);
            IOUtil.closeQuietly(reqInputStream);
        }
        return response;
    }

    private static HttpURLConnection prePost(Configuration config) throws IOException {
        HttpURLConnection con = null;
        con = HttpUtil.getConnection(config);
        HttpUtil.setHeaders(con, config.getReqHeaders());
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-type", "application/json;charset=UTF-8");
        con.setRequestProperty("User-Agent", "suning-sdk-java");
        con.setRequestProperty("Sdk-Version", Configuration.SDKVERSION);
        return con;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeHttpStream(OutputStream out, InputStream reqInputStream, String path, byte[] zipData) throws SuningApiException {
        BufferedOutputStream bos;
        if (null == path && null == zipData) {
            if (null == reqInputStream) return;
            try {
                while (true) {
                    int ch;
                    if ((ch = reqInputStream.read()) == -1) {
                        out.flush();
                        return;
                    }
                    out.write(ch);
                }
            }
            catch (IOException e) {
                throw new SuningApiException(e);
            }
        }
        if (null != path && null == zipData) {
            bos = null;
            FileInputStream fis = null;
            try {
                try {
                    File f = new File(path);
                    int size = (int)f.length();
                    byte[] data = new byte[size];
                    fis = new FileInputStream(f);
                    bos = new BufferedOutputStream(out);
                    fis.read(data, 0, size);
                    bos.write(f.getName().substring(f.getName().lastIndexOf(File.separator) + 1, f.getName().length()).getBytes());
                    bos.write(124);
                    bos.write(data);
                    bos.flush();
                }
                catch (IOException e) {
                    throw new SuningApiException(e);
                }
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                IOUtil.closeQuietly(bos);
                IOUtil.closeQuietly(fis);
                throw throwable;
            }
            IOUtil.closeQuietly(bos);
            IOUtil.closeQuietly(fis);
        }
        if (null != path) return;
        if (null == zipData) return;
        bos = null;
        try {
            try {
                bos = new BufferedOutputStream(out);
                String randomName = UUID.randomUUID().toString().concat(".zip");
                bos.write(randomName.getBytes());
                bos.write(124);
                bos.write(zipData);
                bos.flush();
            }
            catch (IOException e) {
                throw new SuningApiException(e);
            }
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            IOUtil.closeQuietly(bos);
            throw throwable;
        }
        IOUtil.closeQuietly(bos);
    }

    @Deprecated
    static HttpURLConnection getConnection(String connectUrl, int connTimeOut, int readTimeOut) throws IOException {
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)new URL(connectUrl).openConnection();
        if (connTimeOut > 0) {
            conn.setConnectTimeout(connTimeOut * 1000);
        }
        if (readTimeOut > 0) {
            conn.setReadTimeout(readTimeOut * 1000);
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        return conn;
    }

    private static HttpURLConnection getConnection(Configuration config) throws IOException {
        int readTimeOut;
        HttpURLConnection conn = null;
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (null != proxyHost && 0 != proxyPort) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            conn = (HttpURLConnection)new URL(config.getConnectUrl()).openConnection(proxy);
        } else {
            conn = (HttpURLConnection)new URL(config.getConnectUrl()).openConnection();
        }
        int connTimeOut = config.getHttpConnectionTimeout();
        if (connTimeOut > 0) {
            conn.setConnectTimeout(connTimeOut * 1000);
        }
        if ((readTimeOut = config.getHttpReadTimeout()) > 0) {
            conn.setReadTimeout(readTimeOut * 1000);
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        return conn;
    }

    private static boolean setHeaders(HttpURLConnection con, Map<String, String> reqHeaders) {
        if (null != reqHeaders && !reqHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : reqHeaders.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (StringUtil.isEmpty(value)) continue;
                con.addRequestProperty(key, value);
            }
        }
        return true;
    }
}

