/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.util;

import com.suning.api.exception.SuningApiException;
import com.suning.api.message.Message;
import com.suning.api.message.MessageType;
import com.suning.api.util.json.ExceptionErrorListener;
import com.suning.api.util.json.JSONReader;
import com.suning.api.util.json.JSONValidatingReader;
import com.suning.api.util.json.JSONWriter;
import java.util.Date;
import java.util.Map;

public abstract class MessageUtils {
    public static String buildAuthAckMsg(String status) {
        Message authAck = new Message(MessageType.AUTHACK);
        authAck.setMsg(status);
        String msg = null;
        msg = MessageUtils.toMsg(authAck);
        return msg;
    }

    public static String buildAckMsg(Message message) {
        Message ack = new Message(MessageType.ACK);
        ack.setUser(message.getUser());
        ack.setMessageId(message.getMessageId());
        ack.setTopic(message.getTopic());
        ack.setAppKey(message.getAppKey());
        ack.setSendDateTime(new Date());
        return MessageUtils.toMsg(ack);
    }

    public static String toMsg(Message message) {
        JSONWriter writer = new JSONWriter();
        String msg = null;
        try {
            msg = writer.write(message);
        }
        catch (SuningApiException e) {
            e.printStackTrace();
        }
        return msg;
    }

    public static Message toMessage(String msg) {
        Message message = null;
        JSONValidatingReader reader = new JSONValidatingReader(new ExceptionErrorListener());
        Object rootObj = ((JSONReader)reader).read(msg);
        Map messageMap = null;
        if (rootObj instanceof Map) {
            messageMap = (Map)rootObj;
        }
        if (null != messageMap && !messageMap.isEmpty()) {
            message = new Message();
            message.setAppKey((String)messageMap.get("appKey"));
            message.setMessageId((String)messageMap.get("messageId"));
            message.setTopic((String)messageMap.get("topic"));
            message.setUser((String)messageMap.get("user"));
            message.setMsg((String)messageMap.get("msg"));
            String messageType = (String)messageMap.get("messageType");
            if (messageType.equals("FROM")) {
                message.setMessageType(MessageType.FROM);
            } else {
                message.setMessageType(MessageType.ACK);
            }
            message.setSendTime((String)messageMap.get("sendTime"));
            message.setRecevieTime((String)messageMap.get("recevieTime"));
        }
        return message;
    }
}

