/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.util;

import com.suning.api.SelectSuningRequest;
import com.suning.api.SuningRequest;
import com.suning.api.SuningUploadRequest;
import com.suning.api.annotation.ApiField;
import com.suning.api.annotation.ApiNoneParsedField;
import com.suning.api.exception.SuningApiException;
import com.suning.api.util.IOUtil;
import com.suning.api.util.StringUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    private static final Set<String> BASEFIELDS = new HashSet<String>();
    private static final Set<String> BASEUPLOADFIELDS = new HashSet<String>();
    private static final Set<String> BASESELECTFIELDS = new HashSet<String>();
    private static Stack<Object> calls;

    public static <T extends SuningRequest<?>> String toXml(T request) throws SuningApiException {
        Document doc = XmlUtil.createDocument();
        Element root = doc.createElement("sn_request");
        doc.appendChild(root);
        Element bodyElement = doc.createElement("sn_body");
        root.appendChild(bodyElement);
        if (request instanceof SuningRequest) {
            Field[] fields = request.getClass().getDeclaredFields();
            if (null != fields && fields.length == 1) {
                Class<?> fieldType;
                Field field = fields[0];
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                ApiField apiField = field.getAnnotation(ApiField.class);
                String name = field.getName();
                if (null != apiField) {
                    name = apiField.alias();
                }
                if ("java.util.List".equals((fieldType = field.getType()).getName()) && request.getBizName().equals(name)) {
                    XmlUtil.value(request, bodyElement, doc);
                } else {
                    Element serviceElement = doc.createElement(request.getBizName());
                    bodyElement.appendChild(serviceElement);
                    XmlUtil.value(request, serviceElement, doc);
                }
            } else {
                Element serviceElement = doc.createElement(request.getBizName());
                bodyElement.appendChild(serviceElement);
                XmlUtil.value(request, serviceElement, doc);
            }
        } else {
            Element serviceElement = doc.createElement(request.getBizName());
            bodyElement.appendChild(serviceElement);
            XmlUtil.value(request, serviceElement, doc);
        }
        return XmlUtil.docToXmlStr(doc);
    }

    public static Document createDocument() throws SuningApiException {
        Document doc = null;
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SuningApiException(e.getMessage());
        }
        doc = builder.newDocument();
        doc.setXmlStandalone(true);
        return doc;
    }

    public static Document createDocument(String xmlString) throws SuningApiException {
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(xmlString.trim().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            throw new SuningApiException(e1.getMessage());
        }
        return XmlUtil.createDocument(in);
    }

    public static Document createDocument(InputStream xmlStream) throws SuningApiException {
        Document doc = null;
        try {
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                doc = builder.parse(xmlStream);
            }
            catch (ParserConfigurationException e) {
                throw new SuningApiException(e.getMessage());
            }
            catch (SAXException e) {
                throw new SuningApiException(e.getMessage());
            }
            catch (IOException e) {
                throw new SuningApiException(e.getMessage());
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            IOUtil.closeQuietly(xmlStream);
            throw throwable;
        }
        IOUtil.closeQuietly(xmlStream);
        return doc;
    }

    public static String docToXmlStr(Document doc) throws SuningApiException {
        String xmlStr = "";
        Transformer transformer = null;
        DOMSource domSource = new DOMSource(doc);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult xmlResult = new StreamResult(baos);
        try {
            try {
                transformer = transFactory.newTransformer();
                transformer.transform(domSource, xmlResult);
                xmlStr = baos.toString("UTF-8");
            }
            catch (TransformerException e) {
                throw new SuningApiException(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                throw new SuningApiException(e.getMessage());
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            IOUtil.closeQuietly(baos);
            throw throwable;
        }
        IOUtil.closeQuietly(baos);
        return xmlStr;
    }

    public static Element getChildElement(Element parent, String tagName) {
        List<Element> children = XmlUtil.getChildElements(parent, tagName);
        if (children.isEmpty()) {
            return null;
        }
        return children.get(0);
    }

    public static List<Element> getChildElements(Element parent, String tagName) {
        NodeList nodes = parent.getElementsByTagName(tagName);
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element) || node.getParentNode() != parent) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    public static Element getRootElementFromString(String payload) throws SuningApiException {
        if (payload == null || payload.trim().length() < 1) {
            throw new SuningApiException("XML_PAYLOAD_EMPTY");
        }
        byte[] bytes = null;
        try {
            bytes = payload.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SuningApiException("XML_ENCODE_ERROR", e);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return XmlUtil.createDocument(in).getDocumentElement();
    }

    public static String getElementValue(Element parent, String tagName) {
        NodeList nodes;
        Element element = XmlUtil.getChildElement(parent, tagName);
        if (element != null && (nodes = element.getChildNodes()) != null && nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Text)) continue;
                return ((Text)node).getData();
            }
        }
        return null;
    }

    public static String getElementValue(Element element) {
        NodeList nodes;
        if (element != null && (nodes = element.getChildNodes()) != null && nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Text)) continue;
                return ((Text)node).getData();
            }
        }
        return null;
    }

    public static Map<String, Object> parseXmlToMap(String xmlStr) throws SuningApiException {
        return XmlUtil.createMap(XmlUtil.createDocument(xmlStr));
    }

    public static Map<String, Object> parseXmlToMap(InputStream xmlStream) throws SuningApiException {
        return XmlUtil.createMap(XmlUtil.createDocument(xmlStream));
    }

    private static Map<String, Object> createMap(Document doc) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Element root = doc.getDocumentElement();
        NodeList elements = root.getChildNodes();
        if (0 < elements.getLength()) {
            result.put(root.getNodeName(), XmlUtil.getData(root));
        } else {
            result.put(root.getNodeName(), root.getTextContent());
        }
        return result;
    }

    private static Map<String, Object> getData(Node datanode) {
        NodeList elements = datanode.getChildNodes();
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        for (int i = 0; i < elements.getLength(); ++i) {
            List<Object> nestList;
            Node node = elements.item(i);
            String key = node.getNodeName();
            Node lastChild = node.getLastChild();
            if (null != lastChild && lastChild.getNodeType() == 1) {
                if (null == retMap.get(key)) {
                    retMap.put(key, XmlUtil.getData(node));
                    continue;
                }
                nestList = null;
                if (retMap.get(key) instanceof List) {
                    nestList = (List)retMap.get(key);
                } else {
                    nestList = new ArrayList();
                    nestList.add(retMap.get(key));
                }
                nestList.add(XmlUtil.getData(node));
                retMap.put(node.getNodeName(), nestList);
                continue;
            }
            if (null == retMap.get(key)) {
                retMap.put(key, "".equals(node.getNodeValue()) ? null : node.getTextContent());
                continue;
            }
            nestList = null;
            if (retMap.get(key) instanceof List) {
                nestList = (List)retMap.get(key);
            } else {
                nestList = new ArrayList();
                nestList.add(retMap.get(key));
            }
            nestList.add(node.getTextContent());
            retMap.put(node.getNodeName(), nestList);
        }
        return retMap;
    }

    public static String paseMapToXml(Map<?, ?> data) throws SuningApiException {
        return XmlUtil.docToXmlStr(XmlUtil.getDocFromMap(data));
    }

    public static <T extends SuningRequest<?>> String parseBeanToXml(T request) throws SuningApiException {
        Document doc = XmlUtil.createDocument();
        Element root = doc.createElement("sn_request");
        Element bodyElement = doc.createElement("sn_body");
        root.appendChild(bodyElement);
        Element serviceElement = doc.createElement(request.getBizName());
        bodyElement.appendChild(serviceElement);
        XmlUtil.value(request, serviceElement, doc);
        return XmlUtil.docToXmlStr(doc);
    }

    private static Document getDocFromMap(Map<?, ?> data) throws SuningApiException {
        if (1 < data.size()) {
            throw new SuningApiException(new IllegalArgumentException());
        }
        Document doc = XmlUtil.createDocument();
        Node root = null;
        String rootKey = "";
        for (Map.Entry<?, ?> entry : data.entrySet()) {
            rootKey = (String)entry.getKey();
            root = doc.createElement(rootKey);
            doc.appendChild(root);
        }
        if (data.get(rootKey) instanceof String) {
            root.setTextContent(data.get(rootKey).toString());
        } else {
            XmlUtil.nestParse(root, (Map)data.get(rootKey), doc);
        }
        return doc;
    }

    private static void nestParse(Node node, Map<?, ?> data, Document doc) {
        Map<?, ?> dataMap = data;
        String key = "";
        for (Map.Entry<?, ?> entry : dataMap.entrySet()) {
            Node subNode;
            key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                subNode = node.appendChild(doc.createElement(key));
                XmlUtil.nestParse(subNode, (Map)value, doc);
                continue;
            }
            if (value instanceof List) {
                List valList = (List)value;
                for (int i = 0; i < valList.size(); ++i) {
                    Node subNode2 = node.appendChild(doc.createElement(key));
                    if (valList.get(i) instanceof String) {
                        subNode2.setTextContent(valList.get(i).toString());
                        continue;
                    }
                    if (!(valList.get(i) instanceof Map)) continue;
                    XmlUtil.nestParse(subNode2, (Map)valList.get(i), doc);
                }
                continue;
            }
            subNode = node.appendChild(doc.createElement(key));
            if (!StringUtil.isNullOrEmpty(value)) {
                subNode.setTextContent(value.toString());
                continue;
            }
            subNode.setTextContent("");
        }
    }

    private static boolean cyclic(Object object) {
        for (Object e : calls) {
            if (object != e) continue;
            return true;
        }
        return false;
    }

    private static void value(Object object, Element rootElement, Document doc) throws SuningApiException {
        if (object != null && !XmlUtil.cyclic(object)) {
            calls.push(object);
            if (object instanceof Class) {
                Text node = doc.createTextNode(String.valueOf(object));
                rootElement.appendChild(node);
            } else if (object instanceof Boolean) {
                Text node = doc.createTextNode(String.valueOf(object));
                rootElement.appendChild(node);
            } else if (object instanceof Number) {
                Text node = doc.createTextNode(String.valueOf(object));
                rootElement.appendChild(node);
            } else if (object instanceof String) {
                Text node = doc.createTextNode(String.valueOf(object));
                rootElement.appendChild(node);
            } else if (object instanceof Character) {
                Text node = doc.createTextNode(String.valueOf(object));
                rootElement.appendChild(node);
            } else if (object.getClass().isArray()) {
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    XmlUtil.value(Array.get(object, i), rootElement, doc);
                }
            } else if (object instanceof Collection) {
                Iterator it = ((Collection)object).iterator();
                while (it.hasNext()) {
                    XmlUtil.value(it.next(), rootElement, doc);
                }
            } else {
                XmlUtil.bean(object, rootElement, doc);
            }
            calls.pop();
        }
    }

    private static void bean(Object object, Element rootElement, Document doc) throws SuningApiException {
        if (null != object) {
            try {
                BeanInfo info = Introspector.getBeanInfo(object.getClass(), Object.class);
                PropertyDescriptor[] props = info.getPropertyDescriptors();
                for (int i = 0; i < props.length; ++i) {
                    Field field;
                    ApiNoneParsedField noneParseField;
                    PropertyDescriptor prop = props[i];
                    String name = prop.getName();
                    Method getAaccessor = prop.getReadMethod();
                    Method setAaccessor = prop.getWriteMethod();
                    if (getAaccessor == null || setAaccessor == null || "class".equals(name) || getAaccessor == null) continue;
                    if (!getAaccessor.isAccessible()) {
                        getAaccessor.setAccessible(true);
                    }
                    Object value = getAaccessor.invoke(object, (Object[])null);
                    Class<?> clazz = object.getClass();
                    Class<?> superClazz = clazz.getSuperclass();
                    if (SelectSuningRequest.class.getName().equalsIgnoreCase(superClazz.getName()) || SuningUploadRequest.class.getName().equalsIgnoreCase(superClazz.getName())) {
                        superClazz = superClazz.getSuperclass();
                    }
                    if (null != (noneParseField = (field = BASEFIELDS.contains(name) ? superClazz.getDeclaredField(name) : (BASEUPLOADFIELDS.contains(name) ? clazz.getSuperclass().getDeclaredField(name) : (BASESELECTFIELDS.contains(name) ? clazz.getSuperclass().getDeclaredField(name) : clazz.getDeclaredField(name)))).getAnnotation(ApiNoneParsedField.class))) continue;
                    ApiField apiField = field.getAnnotation(ApiField.class);
                    if (null != apiField) {
                        name = apiField.alias();
                    }
                    if (null == value || "".equals(value)) {
                        if (null == apiField) continue;
                        value = apiField.defaultValue();
                    }
                    if (value == null || XmlUtil.cyclic(value)) continue;
                    Class<?> fieldType = field.getType();
                    if ("java.util.List".equals(fieldType.getName())) {
                        if (!(value instanceof Collection)) continue;
                        Iterator it = ((Collection)value).iterator();
                        while (it.hasNext()) {
                            Element element = doc.createElement(name);
                            rootElement.appendChild(element);
                            XmlUtil.value(it.next(), element, doc);
                        }
                        continue;
                    }
                    Element element = doc.createElement(name);
                    rootElement.appendChild(element);
                    XmlUtil.value(value, element, doc);
                }
            }
            catch (IllegalAccessException iae) {
                throw new SuningApiException(iae);
            }
            catch (InvocationTargetException ite) {
                throw new SuningApiException(ite);
            }
            catch (IntrospectionException ie) {
                throw new SuningApiException(ie);
            }
            catch (SecurityException e) {
                throw new SuningApiException(e);
            }
            catch (NoSuchFieldException e) {
                throw new SuningApiException(e);
            }
        }
    }

    static {
        BASEFIELDS.add("code");
        BASEFIELDS.add("body");
        BASEFIELDS.add("rspMap");
        BASEFIELDS.add("reqParam");
        BASEFIELDS.add("sysParams");
        BASESELECTFIELDS.add("pageNo");
        BASESELECTFIELDS.add("pageSize");
        BASEFIELDS.add("appRequestTime");
        BASEFIELDS.add("appMethod");
        BASEFIELDS.add("signInfo");
        BASEFIELDS.add("reqFormat");
        BASEFIELDS.add("resparamsInputType");
        BASEFIELDS.add("checkParam");
        BASEFIELDS.add("resParamsMap");
        BASEFIELDS.add("resparams");
        BASEUPLOADFIELDS.add("path");
        BASEUPLOADFIELDS.add("data");
        calls = new Stack();
    }
}

