/*
 * Decompiled with CFR 0.152.
 */
package com.suning.api.util.json;

import com.suning.api.SelectSuningRequest;
import com.suning.api.SuningRequest;
import com.suning.api.SuningUploadRequest;
import com.suning.api.annotation.ApiField;
import com.suning.api.annotation.ApiNoneParsedField;
import com.suning.api.exception.SuningApiException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONWriter {
    static char[] hex = "0123456789ABCDEF".toCharArray();
    private static final Set<String> BASEFIELDS = new HashSet<String>();
    private static final Set<String> BASEUPLOADFIELDS = new HashSet<String>();
    private static final Set<String> BASESELECTFIELDS = new HashSet<String>();
    private StringBuffer buf = new StringBuffer();
    private Stack<Object> calls = new Stack();
    private DateFormat format;

    public JSONWriter() {
    }

    public JSONWriter(DateFormat format) {
        this.format = format;
    }

    public String write(Object object) throws SuningApiException {
        this.buf.setLength(0);
        this.value(object);
        return this.buf.toString();
    }

    public String write(long n) {
        return String.valueOf(n);
    }

    public String write(double d) {
        return String.valueOf(d);
    }

    public String write(char c) {
        return "\"" + c + "\"";
    }

    public String write(boolean b) {
        return String.valueOf(b);
    }

    private void value(Object object) throws SuningApiException {
        if (object != null && !this.cyclic(object)) {
            this.calls.push(object);
            if (object instanceof Class) {
                this.string(object);
            } else if (object instanceof Boolean) {
                this.bool((Boolean)object);
            } else if (object instanceof Number) {
                this.add(object);
            } else if (object instanceof String) {
                this.string(object);
            } else if (object instanceof Character) {
                this.string(object);
            } else if (object instanceof Map) {
                this.map((Map)object);
            } else if (object.getClass().isArray()) {
                this.array(object);
            } else if (object instanceof Iterator) {
                this.array((Iterator)object);
            } else if (object instanceof Collection) {
                this.array(((Collection)object).iterator());
            } else if (object instanceof Date) {
                this.date((Date)object);
            } else if (object instanceof Enum) {
                this.string(object);
            } else {
                this.bean(object);
            }
            this.calls.pop();
        }
    }

    private boolean cyclic(Object object) {
        for (Object e : this.calls) {
            if (object != e) continue;
            return true;
        }
        return false;
    }

    private void bean(Object object) throws SuningApiException {
        this.add('{');
        boolean addedSomething = false;
        try {
            BeanInfo info = Introspector.getBeanInfo(object.getClass(), Object.class);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                Field field;
                ApiNoneParsedField noneParseField;
                PropertyDescriptor prop = props[i];
                String name = prop.getName();
                Method getAaccessor = prop.getReadMethod();
                Method setAaccessor = prop.getWriteMethod();
                if (getAaccessor == null || setAaccessor == null || "class".equals(name) || getAaccessor == null) continue;
                if (!getAaccessor.isAccessible()) {
                    getAaccessor.setAccessible(true);
                }
                Object value = getAaccessor.invoke(object, (Object[])null);
                Class<?> clazz = object.getClass();
                Class<?> superClazz = clazz.getSuperclass();
                if (SelectSuningRequest.class.getName().equalsIgnoreCase(superClazz.getName()) || SuningUploadRequest.class.getName().equalsIgnoreCase(superClazz.getName())) {
                    superClazz = superClazz.getSuperclass();
                }
                if (null != (noneParseField = (field = SuningRequest.class.getName().equalsIgnoreCase(superClazz.getName()) && "code".equals(name) ? clazz.getDeclaredField(name) : (BASEFIELDS.contains(name) ? superClazz.getDeclaredField(name) : (BASEUPLOADFIELDS.contains(name) ? clazz.getSuperclass().getDeclaredField(name) : (BASESELECTFIELDS.contains(name) ? clazz.getSuperclass().getDeclaredField(name) : clazz.getDeclaredField(name))))).getAnnotation(ApiNoneParsedField.class))) continue;
                ApiField jsonField = field.getAnnotation(ApiField.class);
                if (null != jsonField) {
                    name = jsonField.alias();
                }
                if (null == value || "".equals(value) || value.equals(0) || value.equals(0.0)) {
                    if (null == jsonField || jsonField.optional()) continue;
                    value = jsonField.defaultValue();
                }
                if (value == null || this.cyclic(value)) continue;
                if (addedSomething) {
                    this.add(',');
                }
                if (value.getClass().equals(Double.class) || value.getClass().equals(Integer.class)) {
                    this.add(name, String.valueOf(value));
                } else {
                    this.add(name, value);
                }
                addedSomething = true;
            }
        }
        catch (IllegalAccessException iae) {
            throw new SuningApiException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new SuningApiException(ite);
        }
        catch (IntrospectionException ie) {
            throw new SuningApiException(ie);
        }
        catch (SecurityException e) {
            throw new SuningApiException(e);
        }
        catch (NoSuchFieldException e) {
            throw new SuningApiException(e);
        }
        this.add('}');
    }

    private void add(String name, Object value) throws SuningApiException {
        this.add('\"');
        this.add(name);
        this.add("\":");
        this.value(value);
    }

    private void map(Map<?, ?> map) throws SuningApiException {
        this.add('{');
        Iterator<Map.Entry<?, ?>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<?, ?> e = it.next();
            this.value(e.getKey());
            this.add(':');
            this.value(e.getValue());
            if (!it.hasNext()) continue;
            this.add(',');
        }
        this.add('}');
    }

    private void array(Iterator<?> it) throws SuningApiException {
        this.add('[');
        while (it.hasNext()) {
            this.value(it.next());
            if (!it.hasNext()) continue;
            this.add(',');
        }
        this.add(']');
    }

    private void array(Object object) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, SuningApiException {
        this.add('[');
        int length = Array.getLength(object);
        for (int i = 0; i < length; ++i) {
            this.value(Array.get(object, i));
            if (i >= length - 1) continue;
            this.add(',');
        }
        this.add(']');
    }

    private void bool(boolean b) {
        this.add(b ? "true" : "false");
    }

    private void date(Date date) {
        if (this.format == null) {
            this.format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        }
        this.add("\"");
        this.add(this.format.format(date));
        this.add("\"");
    }

    private void string(Object obj) {
        this.add('\"');
        StringCharacterIterator it = new StringCharacterIterator(obj.toString());
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\"') {
                this.add("\\\"");
            } else if (c == '\\') {
                this.add("\\\\");
            } else if (c == '/') {
                this.add("\\/");
            } else if (c == '\b') {
                this.add("\\b");
            } else if (c == '\f') {
                this.add("\\f");
            } else if (c == '\n') {
                this.add("\\n");
            } else if (c == '\r') {
                this.add("\\r");
            } else if (c == '\t') {
                this.add("\\t");
            } else if (Character.isISOControl(c)) {
                this.unicode(c);
            } else {
                this.add(c);
            }
            c = it.next();
        }
        this.add('\"');
    }

    private void add(Object obj) {
        this.buf.append(obj);
    }

    private void add(char c) {
        this.buf.append(c);
    }

    private void unicode(char c) {
        this.add("\\u");
        int n = c;
        for (int i = 0; i < 4; ++i) {
            int digit = (n & 0xF000) >> 12;
            this.add(hex[digit]);
            n <<= 4;
        }
    }

    static {
        BASEFIELDS.add("code");
        BASEFIELDS.add("body");
        BASEFIELDS.add("rspMap");
        BASEFIELDS.add("reqParam");
        BASEFIELDS.add("sysParams");
        BASESELECTFIELDS.add("pageNo");
        BASESELECTFIELDS.add("pageSize");
        BASEFIELDS.add("appRequestTime");
        BASEFIELDS.add("appMethod");
        BASEFIELDS.add("signInfo");
        BASEFIELDS.add("reqFormat");
        BASEFIELDS.add("resparamsInputType");
        BASEFIELDS.add("checkParam");
        BASEFIELDS.add("resParamsMap");
        BASEFIELDS.add("resparams");
        BASEUPLOADFIELDS.add("picContent");
        BASEUPLOADFIELDS.add("picItem");
    }
}

