/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.avatargenerator.layers.others;

import com.talanlabs.avatargenerator.IAvatarInfo;
import com.talanlabs.avatargenerator.layers.ILayer;
import com.talanlabs.avatargenerator.utils.AvatarUtils;
import java.awt.image.BufferedImage;

public class RatioLayer
implements ILayer {
    private double ratio;

    public RatioLayer(double ratio) {
        this.ratio = ratio;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    @Override
    public BufferedImage apply(IAvatarInfo avatarInfo, BufferedImage src) {
        int height;
        int width = src.getWidth();
        if ((double)(width / (height = src.getHeight())) == this.ratio) {
            return src;
        }
        if (this.ratio >= 1.0) {
            if (width > height) {
                height = (int)((double)width / this.ratio);
            } else {
                width = (int)((double)height / this.ratio);
            }
        }
        return AvatarUtils.planImage(src, width, height);
    }
}

