/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.avatargenerator.layers.shadows;

import com.talanlabs.avatargenerator.IAvatarInfo;
import com.talanlabs.avatargenerator.layers.shadows.AbstractShadowLayer;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class ScoreShadowLayer
extends AbstractShadowLayer {
    private Color shadowColor;

    public ScoreShadowLayer() {
        this(new Color(0, 0, 0, 24));
    }

    public ScoreShadowLayer(Color shadowColor) {
        super(false);
        this.shadowColor = shadowColor;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
    }

    @Override
    protected BufferedImage buildShadow(IAvatarInfo avatarInfo, BufferedImage src) {
        int width = src.getWidth();
        int height = src.getHeight();
        int[] colors = new int[]{this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), this.shadowColor.getAlpha()};
        BufferedImage dest = new BufferedImage(width, height, 2);
        for (int y = 0; y < height / 2; ++y) {
            for (int x = 0; x < width; ++x) {
                dest.getRaster().setPixel(x, y, colors);
            }
        }
        return dest;
    }
}

