/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONScanner;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class UInt64Codec
implements ObjectSerializer,
ObjectDeserializer {
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object instanceof Long) {
            long value = (Long)object;
            if (value < 0L) {
                String encodedValue = Long.toUnsignedString(value);
                out.writeString(encodedValue);
            } else {
                out.writeLong(value);
            }
        } else {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
        }
    }

    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Long longObject;
        JSONLexer lexer = parser.lexer;
        try {
            int token = lexer.token();
            if (token == 2) {
                long longValue = lexer.longValue();
                lexer.nextToken(16);
                longObject = longValue;
            } else if (token == 3) {
                BigDecimal number = lexer.decimalValue();
                longObject = TypeUtils.longValue((BigDecimal)number);
                lexer.nextToken(16);
            } else {
                if (token == 12) {
                    JSONObject jsonObject = new JSONObject(true);
                    parser.parseObject((Map)jsonObject);
                    longObject = UInt64Codec.castToLong(jsonObject);
                } else {
                    Object value = parser.parse();
                    longObject = UInt64Codec.castToLong(value);
                }
                if (longObject == null) {
                    return null;
                }
            }
        }
        catch (Exception ex) {
            throw new JSONException("parseLong error, field : " + fieldName, (Throwable)ex);
        }
        return (T)(clazz == AtomicLong.class ? new AtomicLong(longObject) : longObject);
    }

    public int getFastMatchToken() {
        return 2;
    }

    public static Long castToLong(Object value) {
        Map map;
        block11: {
            if (value == null) {
                return null;
            }
            if (value instanceof BigDecimal) {
                return TypeUtils.longValue((BigDecimal)((BigDecimal)value));
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                String strVal = (String)value;
                if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                    return null;
                }
                if (strVal.indexOf(44) != -1) {
                    strVal = strVal.replaceAll(",", "");
                }
                try {
                    BigInteger number = new BigInteger(strVal);
                    return number.longValue();
                }
                catch (NumberFormatException number) {
                    JSONScanner dateParser = new JSONScanner(strVal);
                    Calendar calendar = null;
                    if (dateParser.scanISO8601DateIfMatch(false)) {
                        calendar = dateParser.getCalendar();
                    }
                    dateParser.close();
                    if (calendar == null) break block11;
                    return calendar.getTimeInMillis();
                }
            }
        }
        if (value instanceof Map && (map = (Map)value).size() == 2 && map.containsKey("andIncrement") && map.containsKey("andDecrement")) {
            Iterator iter = map.values().iterator();
            iter.next();
            Object value2 = iter.next();
            return UInt64Codec.castToLong(value2);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        throw new JSONException("can not cast to long, value : " + value);
    }
}

