/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.config;

import com.tencent.cloud.metadata.core.DecodeTransferMetadataReactiveFilter;
import com.tencent.cloud.metadata.core.DecodeTransferMetadataServletFilter;
import com.tencent.cloud.metadata.core.EncodeTransferMedataFeignInterceptor;
import com.tencent.cloud.metadata.core.EncodeTransferMedataRestTemplateInterceptor;
import com.tencent.cloud.metadata.core.EncodeTransferMedataScgFilter;
import com.tencent.cloud.metadata.core.EncodeTransferMedataWebClientFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
public class MetadataTransferAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    protected static class MetadataTransferWebClientConfig {
        @Autowired(required=false)
        private List<WebClient.Builder> webClientBuilder = Collections.emptyList();

        protected MetadataTransferWebClientConfig() {
        }

        @Bean
        public EncodeTransferMedataWebClientFilter encodeTransferMedataWebClientFilter() {
            return new EncodeTransferMedataWebClientFilter();
        }

        @Bean
        public SmartInitializingSingleton addEncodeTransferMetadataFilterForWebClient(EncodeTransferMedataWebClientFilter filter) {
            return () -> this.webClientBuilder.forEach(webClient -> webClient.filter((ExchangeFilterFunction)filter));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    protected static class MetadataTransferRestTemplateConfig {
        @Autowired(required=false)
        private List<RestTemplate> restTemplates = Collections.emptyList();

        protected MetadataTransferRestTemplateConfig() {
        }

        @Bean
        public EncodeTransferMedataRestTemplateInterceptor encodeTransferMedataRestTemplateInterceptor() {
            return new EncodeTransferMedataRestTemplateInterceptor();
        }

        @Bean
        public SmartInitializingSingleton addEncodeTransferMetadataInterceptorForRestTemplate(EncodeTransferMedataRestTemplateInterceptor interceptor) {
            return () -> this.restTemplates.forEach(restTemplate -> {
                ArrayList<EncodeTransferMedataRestTemplateInterceptor> list = new ArrayList<EncodeTransferMedataRestTemplateInterceptor>(restTemplate.getInterceptors());
                list.add(interceptor);
                restTemplate.setInterceptors(list);
            });
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"feign.Feign"})
    protected static class MetadataTransferFeignInterceptorConfig {
        protected MetadataTransferFeignInterceptorConfig() {
        }

        @Bean
        public EncodeTransferMedataFeignInterceptor encodeTransferMedataFeignInterceptor() {
            return new EncodeTransferMedataFeignInterceptor();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.cloud.gateway.filter.GlobalFilter"})
    protected static class MetadataTransferScgFilterConfig {
        protected MetadataTransferScgFilterConfig() {
        }

        @Bean
        public GlobalFilter encodeTransferMedataScgFilter() {
            return new EncodeTransferMedataScgFilter();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    protected static class MetadataReactiveFilterConfig {
        protected MetadataReactiveFilterConfig() {
        }

        @Bean
        public DecodeTransferMetadataReactiveFilter metadataReactiveFilter() {
            return new DecodeTransferMetadataReactiveFilter();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    protected static class MetadataServletFilterConfig {
        protected MetadataServletFilterConfig() {
        }

        @Bean
        public FilterRegistrationBean<DecodeTransferMetadataServletFilter> metadataServletFilterRegistrationBean(DecodeTransferMetadataServletFilter decodeTransferMetadataServletFilter) {
            FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)decodeTransferMetadataServletFilter, new ServletRegistrationBean[0]);
            filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
            filterRegistrationBean.setOrder(-2147483639);
            return filterRegistrationBean;
        }

        @Bean
        public DecodeTransferMetadataServletFilter metadataServletFilter() {
            return new DecodeTransferMetadataServletFilter();
        }
    }
}

