/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.core;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.common.util.JacksonUtils;
import com.tencent.cloud.metadata.core.CustomTransitiveMetadataResolver;
import com.tencent.cloud.metadata.core.TransHeadersTransfer;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class DecodeTransferMetadataReactiveFilter
implements WebFilter,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(DecodeTransferMetadataReactiveFilter.class);

    public int getOrder() {
        return -2147483639;
    }

    public Mono<Void> filter(ServerWebExchange serverWebExchange, WebFilterChain webFilterChain) {
        ServerHttpRequest serverHttpRequest = serverWebExchange.getRequest();
        Map<String, String> internalTransitiveMetadata = this.getIntervalMetadata(serverHttpRequest, "SCT-CUSTOM-METADATA");
        Map<String, String> customTransitiveMetadata = CustomTransitiveMetadataResolver.resolve(serverWebExchange);
        HashMap<String, String> mergedTransitiveMetadata = new HashMap<String, String>();
        mergedTransitiveMetadata.putAll(internalTransitiveMetadata);
        mergedTransitiveMetadata.putAll(customTransitiveMetadata);
        Map<String, String> internalDisposableMetadata = this.getIntervalMetadata(serverHttpRequest, "SCT-CUSTOM-DISPOSABLE-METADATA");
        HashMap<String, String> mergedDisposableMetadata = new HashMap<String, String>(internalDisposableMetadata);
        MetadataContextHolder.init(mergedTransitiveMetadata, mergedDisposableMetadata);
        serverWebExchange.getAttributes().put("SCT-METADATA-CONTEXT", MetadataContextHolder.get());
        TransHeadersTransfer.transfer(serverHttpRequest);
        return webFilterChain.filter(serverWebExchange).doOnError(throwable -> LOG.error("handle metadata[{}] error.", (Object)MetadataContextHolder.get(), throwable)).doFinally(type -> MetadataContextHolder.remove());
    }

    private Map<String, String> getIntervalMetadata(ServerHttpRequest serverHttpRequest, String headerName) {
        HttpHeaders httpHeaders = serverHttpRequest.getHeaders();
        String customMetadataStr = httpHeaders.getFirst(headerName);
        try {
            if (StringUtils.hasText((String)customMetadataStr)) {
                customMetadataStr = URLDecoder.decode(customMetadataStr, ContextConstant.UTF_8);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Runtime system does not support utf-8 coding.", (Throwable)e);
        }
        LOG.debug("Get upstream metadata string: {}", (Object)customMetadataStr);
        return JacksonUtils.deserialize2Map((String)customMetadataStr);
    }
}

