/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.core;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.common.util.JacksonUtils;
import com.tencent.cloud.metadata.core.CustomTransitiveMetadataResolver;
import com.tencent.cloud.metadata.core.TransHeadersTransfer;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Order(value=-2147483639)
public class DecodeTransferMetadataServletFilter
extends OncePerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(DecodeTransferMetadataServletFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NonNull HttpServletRequest httpServletRequest, @NonNull HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        Map<String, String> internalTransitiveMetadata = this.getInternalMetadata(httpServletRequest, "SCT-CUSTOM-METADATA");
        Map<String, String> customTransitiveMetadata = CustomTransitiveMetadataResolver.resolve(httpServletRequest);
        HashMap<String, String> mergedTransitiveMetadata = new HashMap<String, String>();
        mergedTransitiveMetadata.putAll(internalTransitiveMetadata);
        mergedTransitiveMetadata.putAll(customTransitiveMetadata);
        Map<String, String> internalDisposableMetadata = this.getInternalMetadata(httpServletRequest, "SCT-CUSTOM-DISPOSABLE-METADATA");
        HashMap<String, String> mergedDisposableMetadata = new HashMap<String, String>(internalDisposableMetadata);
        MetadataContextHolder.init(mergedTransitiveMetadata, mergedDisposableMetadata);
        TransHeadersTransfer.transfer(httpServletRequest);
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        finally {
            MetadataContextHolder.remove();
        }
    }

    private Map<String, String> getInternalMetadata(HttpServletRequest httpServletRequest, String headerName) {
        String customMetadataStr = httpServletRequest.getHeader(headerName);
        try {
            if (StringUtils.hasText((String)customMetadataStr)) {
                customMetadataStr = URLDecoder.decode(customMetadataStr, ContextConstant.UTF_8);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Runtime system does not support utf-8 coding.", (Throwable)e);
        }
        LOG.debug("Get upstream metadata string: {}", (Object)customMetadataStr);
        return JacksonUtils.deserialize2Map((String)customMetadataStr);
    }
}

