/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.core;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.common.util.JacksonUtils;
import com.tencent.cloud.metadata.core.TransHeadersTransfer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class EncodeTransferMedataScgFilter
implements GlobalFilter,
Ordered {
    private static final int METADATA_SCG_FILTER_ORDER = 10151;

    public int getOrder() {
        return 10151;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest.Builder builder = exchange.getRequest().mutate();
        MetadataContext metadataContext = (MetadataContext)exchange.getAttribute("SCT-METADATA-CONTEXT");
        if (metadataContext == null) {
            metadataContext = MetadataContextHolder.get();
        }
        Map customMetadata = metadataContext.getCustomMetadata();
        Map disposableMetadata = metadataContext.getDisposableMetadata();
        this.buildMetadataHeader(builder, customMetadata, "SCT-CUSTOM-METADATA");
        this.buildMetadataHeader(builder, disposableMetadata, "SCT-CUSTOM-DISPOSABLE-METADATA");
        TransHeadersTransfer.transfer(exchange.getRequest());
        return chain.filter(exchange.mutate().request(builder.build()).build());
    }

    private void buildMetadataHeader(ServerHttpRequest.Builder builder, Map<String, String> metadata, String headerName) {
        if (!CollectionUtils.isEmpty(metadata)) {
            String encodedMetadata = JacksonUtils.serialize2Json(metadata);
            try {
                builder.header(headerName, new String[]{URLEncoder.encode(encodedMetadata, ContextConstant.UTF_8)});
            }
            catch (UnsupportedEncodingException e) {
                builder.header(headerName, new String[]{encodedMetadata});
            }
        }
    }
}

