/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.metadata.core;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.common.util.JacksonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class EncodeTransferMedataWebClientFilter
implements ExchangeFilterFunction {
    public Mono<ClientResponse> filter(ClientRequest clientRequest, ExchangeFunction next) {
        MetadataContext metadataContext = MetadataContextHolder.get();
        Map customMetadata = metadataContext.getCustomMetadata();
        Map disposableMetadata = metadataContext.getDisposableMetadata();
        Map transHeaders = metadataContext.getTransHeadersKV();
        ClientRequest.Builder requestBuilder = ClientRequest.from((ClientRequest)clientRequest);
        this.buildMetadataHeader(requestBuilder, customMetadata, "SCT-CUSTOM-METADATA");
        this.buildMetadataHeader(requestBuilder, disposableMetadata, "SCT-CUSTOM-DISPOSABLE-METADATA");
        this.buildTransmittedHeader(requestBuilder, transHeaders);
        ClientRequest request = requestBuilder.build();
        return next.exchange(request);
    }

    private void buildTransmittedHeader(ClientRequest.Builder requestBuilder, Map<String, String> transHeaders) {
        if (!CollectionUtils.isEmpty(transHeaders)) {
            transHeaders.forEach((x$0, xva$1) -> requestBuilder.header(x$0, new String[]{xva$1}));
        }
    }

    private void buildMetadataHeader(ClientRequest.Builder requestBuilder, Map<String, String> metadata, String headerName) {
        if (!CollectionUtils.isEmpty(metadata)) {
            String encodedMetadata = JacksonUtils.serialize2Json(metadata);
            try {
                requestBuilder.header(headerName, new String[]{URLEncoder.encode(encodedMetadata, ContextConstant.UTF_8)});
            }
            catch (UnsupportedEncodingException e) {
                requestBuilder.header(headerName, new String[]{encodedMetadata});
            }
        }
    }
}

