/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker;

import com.tencent.cloud.polaris.circuitbreaker.common.PolarisCircuitBreakerConfigBuilder;
import com.tencent.cloud.polaris.circuitbreaker.common.PolarisResultToErrorCode;
import com.tencent.cloud.polaris.circuitbreaker.util.PolarisCircuitBreakerUtils;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.circuitbreak.api.CircuitBreakAPI;
import com.tencent.polaris.circuitbreak.api.FunctionalDecorator;
import com.tencent.polaris.circuitbreak.api.pojo.FunctionalDecoratorRequest;
import com.tencent.polaris.circuitbreak.api.pojo.ResultToErrorCode;
import com.tencent.polaris.circuitbreak.client.exception.CallAbortedException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;

public class PolarisCircuitBreaker
implements CircuitBreaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisCircuitBreaker.class);
    private final FunctionalDecorator decorator;
    private final PolarisCircuitBreakerConfigBuilder.PolarisCircuitBreakerConfiguration conf;
    private final ConsumerAPI consumerAPI;

    public PolarisCircuitBreaker(PolarisCircuitBreakerConfigBuilder.PolarisCircuitBreakerConfiguration conf, ConsumerAPI consumerAPI, CircuitBreakAPI circuitBreakAPI) {
        FunctionalDecoratorRequest makeDecoratorRequest = new FunctionalDecoratorRequest(new ServiceKey(conf.getNamespace(), conf.getService()), conf.getMethod());
        makeDecoratorRequest.setSourceService(new ServiceKey(conf.getSourceNamespace(), conf.getSourceService()));
        makeDecoratorRequest.setResultToErrorCode((ResultToErrorCode)new PolarisResultToErrorCode());
        this.consumerAPI = consumerAPI;
        this.conf = conf;
        this.decorator = circuitBreakAPI.makeFunctionalDecorator(makeDecoratorRequest);
    }

    public <T> T run(Supplier<T> toRun, Function<Throwable, T> fallback) {
        Supplier toRunDecorator = this.decorator.decorateSupplier(toRun);
        try {
            return toRunDecorator.get();
        }
        catch (CallAbortedException e) {
            LOGGER.debug("PolarisCircuitBreaker CallAbortedException: {}", (Object)e.getMessage());
            PolarisCircuitBreakerUtils.reportStatus(this.consumerAPI, this.conf, e);
            return fallback.apply(e);
        }
        catch (Exception e) {
            return fallback.apply(e);
        }
    }
}

