/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker;

import com.tencent.cloud.polaris.circuitbreaker.common.PolarisCircuitBreakerConfigBuilder;
import com.tencent.cloud.polaris.circuitbreaker.common.PolarisResultToErrorCode;
import com.tencent.cloud.polaris.circuitbreaker.reactor.PolarisCircuitBreakerReactorTransformer;
import com.tencent.cloud.polaris.circuitbreaker.util.PolarisCircuitBreakerUtils;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.circuitbreak.api.CircuitBreakAPI;
import com.tencent.polaris.circuitbreak.api.InvokeHandler;
import com.tencent.polaris.circuitbreak.api.pojo.FunctionalDecoratorRequest;
import com.tencent.polaris.circuitbreak.api.pojo.InvokeContext;
import com.tencent.polaris.circuitbreak.api.pojo.ResultToErrorCode;
import com.tencent.polaris.circuitbreak.client.exception.CallAbortedException;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactivePolarisCircuitBreaker
implements ReactiveCircuitBreaker {
    private final InvokeHandler invokeHandler;
    private final ConsumerAPI consumerAPI;
    private final PolarisCircuitBreakerConfigBuilder.PolarisCircuitBreakerConfiguration conf;

    public ReactivePolarisCircuitBreaker(PolarisCircuitBreakerConfigBuilder.PolarisCircuitBreakerConfiguration conf, ConsumerAPI consumerAPI, CircuitBreakAPI circuitBreakAPI) {
        FunctionalDecoratorRequest requestContext = new FunctionalDecoratorRequest(new ServiceKey(conf.getNamespace(), conf.getService()), conf.getMethod());
        requestContext.setSourceService(new ServiceKey(conf.getSourceNamespace(), conf.getSourceService()));
        requestContext.setResultToErrorCode((ResultToErrorCode)new PolarisResultToErrorCode());
        this.consumerAPI = consumerAPI;
        this.conf = conf;
        this.invokeHandler = circuitBreakAPI.makeInvokeHandler((InvokeContext.RequestContext)requestContext);
    }

    public <T> Mono<T> run(Mono<T> toRun, Function<Throwable, Mono<T>> fallback) {
        Mono toReturn = toRun.transform(new PolarisCircuitBreakerReactorTransformer(this.invokeHandler));
        if (fallback != null) {
            toReturn = toReturn.onErrorResume(throwable -> {
                if (throwable instanceof CallAbortedException) {
                    PolarisCircuitBreakerUtils.reportStatus(this.consumerAPI, this.conf, (CallAbortedException)throwable);
                }
                return (Mono)fallback.apply((Throwable)throwable);
            });
        }
        return toReturn;
    }

    public <T> Flux<T> run(Flux<T> toRun, Function<Throwable, Flux<T>> fallback) {
        Flux toReturn = toRun.transform(new PolarisCircuitBreakerReactorTransformer(this.invokeHandler));
        if (fallback != null) {
            toReturn = toReturn.onErrorResume(throwable -> {
                if (throwable instanceof CallAbortedException) {
                    PolarisCircuitBreakerUtils.reportStatus(this.consumerAPI, this.conf, (CallAbortedException)throwable);
                }
                return (Publisher)fallback.apply((Throwable)throwable);
            });
        }
        return toReturn;
    }
}

