/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker;

import com.tencent.cloud.polaris.circuitbreaker.ReactivePolarisCircuitBreaker;
import com.tencent.cloud.polaris.circuitbreaker.common.PolarisCircuitBreakerConfigBuilder;
import com.tencent.cloud.polaris.circuitbreaker.util.PolarisCircuitBreakerUtils;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.circuitbreak.api.CircuitBreakAPI;
import java.util.function.Function;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;

public class ReactivePolarisCircuitBreakerFactory
extends ReactiveCircuitBreakerFactory<PolarisCircuitBreakerConfigBuilder.PolarisCircuitBreakerConfiguration, PolarisCircuitBreakerConfigBuilder> {
    private Function<String, PolarisCircuitBreakerConfigBuilder.PolarisCircuitBreakerConfiguration> defaultConfiguration = id -> {
        String[] metadata = PolarisCircuitBreakerUtils.resolveCircuitBreakerId(id);
        return new PolarisCircuitBreakerConfigBuilder().namespace(metadata[0]).service(metadata[1]).method(metadata[2]).build();
    };
    private final CircuitBreakAPI circuitBreakAPI;
    private final ConsumerAPI consumerAPI;

    public ReactivePolarisCircuitBreakerFactory(CircuitBreakAPI circuitBreakAPI, ConsumerAPI consumerAPI) {
        this.circuitBreakAPI = circuitBreakAPI;
        this.consumerAPI = consumerAPI;
    }

    public ReactiveCircuitBreaker create(String id) {
        PolarisCircuitBreakerConfigBuilder.PolarisCircuitBreakerConfiguration conf = this.getConfigurations().computeIfAbsent(id, this.defaultConfiguration);
        return new ReactivePolarisCircuitBreaker(conf, this.consumerAPI, this.circuitBreakAPI);
    }

    protected PolarisCircuitBreakerConfigBuilder configBuilder(String id) {
        String[] metadata = PolarisCircuitBreakerUtils.resolveCircuitBreakerId(id);
        return new PolarisCircuitBreakerConfigBuilder(metadata[0], metadata[1], metadata[2]);
    }

    public void configureDefault(Function<String, PolarisCircuitBreakerConfigBuilder.PolarisCircuitBreakerConfiguration> defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }
}

