/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker.common;

import com.tencent.cloud.common.metadata.MetadataContext;
import org.springframework.cloud.client.circuitbreaker.ConfigBuilder;

public class PolarisCircuitBreakerConfigBuilder
implements ConfigBuilder<PolarisCircuitBreakerConfiguration> {
    private String namespace = MetadataContext.LOCAL_NAMESPACE;
    private String service;
    private String method;

    public PolarisCircuitBreakerConfigBuilder() {
    }

    public PolarisCircuitBreakerConfigBuilder(String namespace, String service, String method) {
        this.namespace = namespace;
        this.service = service;
        this.method = method;
    }

    public PolarisCircuitBreakerConfigBuilder namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public PolarisCircuitBreakerConfigBuilder service(String service) {
        this.service = service;
        return this;
    }

    public PolarisCircuitBreakerConfigBuilder method(String method) {
        this.method = method;
        return this;
    }

    public PolarisCircuitBreakerConfiguration build() {
        PolarisCircuitBreakerConfiguration conf = new PolarisCircuitBreakerConfiguration();
        conf.setNamespace(this.namespace);
        conf.setService(this.service);
        conf.setMethod(this.method);
        return conf;
    }

    public static class PolarisCircuitBreakerConfiguration {
        private final String sourceNamespace = MetadataContext.LOCAL_NAMESPACE;
        private final String sourceService = MetadataContext.LOCAL_SERVICE;
        private String namespace;
        private String service;
        private String method;

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getSourceNamespace() {
            return this.sourceNamespace;
        }

        public String getSourceService() {
            return this.sourceService;
        }
    }
}

