/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker.common;

import com.tencent.polaris.circuitbreak.api.pojo.ResultToErrorCode;
import feign.FeignException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.reactive.function.client.WebClientResponseException;

public class PolarisResultToErrorCode
implements ResultToErrorCode {
    public int onSuccess(Object value) {
        return 200;
    }

    public int onError(Throwable e) {
        if (this.checkClassExist("org.springframework.web.client.RestClientResponseException") && e instanceof RestClientResponseException) {
            return ((RestClientResponseException)e).getRawStatusCode();
        }
        if (this.checkClassExist("feign.FeignException") && e instanceof FeignException) {
            return ((FeignException)e).status();
        }
        if (this.checkClassExist("org.springframework.web.reactive.function.client.WebClientResponseException") && e instanceof WebClientResponseException) {
            return ((WebClientResponseException)e).getRawStatusCode();
        }
        return -1;
    }

    private boolean checkClassExist(String clazzName) {
        try {
            Class.forName(clazzName, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

