/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker.config;

import com.tencent.cloud.polaris.circuitbreaker.config.ConditionalOnPolarisCircuitBreakerEnabled;
import com.tencent.cloud.polaris.circuitbreaker.feign.PolarisCircuitBreakerNameResolver;
import com.tencent.cloud.polaris.circuitbreaker.feign.PolarisFeignCircuitBreaker;
import com.tencent.cloud.polaris.circuitbreaker.feign.PolarisFeignCircuitBreakerTargeter;
import feign.Feign;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.openfeign.CircuitBreakerNameResolver;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.Targeter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Feign.class, FeignClientFactoryBean.class})
@ConditionalOnPolarisCircuitBreakerEnabled
public class PolarisCircuitBreakerFeignClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CircuitBreakerNameResolver.class})
    public CircuitBreakerNameResolver polarisCircuitBreakerNameResolver() {
        return new PolarisCircuitBreakerNameResolver();
    }

    @Bean
    @ConditionalOnBean(value={CircuitBreakerFactory.class})
    @ConditionalOnMissingBean(value={Targeter.class})
    public Targeter polarisFeignCircuitBreakerTargeter(CircuitBreakerFactory circuitBreakerFactory, CircuitBreakerNameResolver circuitBreakerNameResolver) {
        return new PolarisFeignCircuitBreakerTargeter(circuitBreakerFactory, circuitBreakerNameResolver);
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnBean(value={CircuitBreakerFactory.class})
    @ConditionalOnMissingBean(value={Feign.Builder.class})
    public Feign.Builder circuitBreakerFeignBuilder() {
        return PolarisFeignCircuitBreaker.builder();
    }
}

