/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker.config;

import com.tencent.cloud.polaris.circuitbreaker.ReactivePolarisCircuitBreakerFactory;
import com.tencent.cloud.polaris.circuitbreaker.common.CircuitBreakerConfigModifier;
import com.tencent.cloud.polaris.circuitbreaker.config.ConditionalOnPolarisCircuitBreakerEnabled;
import com.tencent.cloud.polaris.circuitbreaker.reporter.ExceptionCircuitBreakerReporter;
import com.tencent.cloud.polaris.circuitbreaker.reporter.SuccessCircuitBreakerReporter;
import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementAutoConfiguration;
import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementReporterProperties;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.circuitbreak.api.CircuitBreakAPI;
import com.tencent.polaris.circuitbreak.factory.CircuitBreakAPIFactory;
import com.tencent.polaris.client.api.SDKContext;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"reactor.core.publisher.Mono", "reactor.core.publisher.Flux"})
@ConditionalOnPolarisCircuitBreakerEnabled
@AutoConfigureAfter(value={RpcEnhancementAutoConfiguration.class})
public class ReactivePolarisCircuitBreakerAutoConfiguration {
    @Autowired(required=false)
    private List<Customizer<ReactivePolarisCircuitBreakerFactory>> customizers = new ArrayList<Customizer<ReactivePolarisCircuitBreakerFactory>>();

    @Bean
    @ConditionalOnMissingBean(value={CircuitBreakAPI.class})
    public CircuitBreakAPI circuitBreakAPI(SDKContext polarisContext) {
        return CircuitBreakAPIFactory.createCircuitBreakAPIByContext((SDKContext)polarisContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={SuccessCircuitBreakerReporter.class})
    public SuccessCircuitBreakerReporter successCircuitBreakerReporter(RpcEnhancementReporterProperties properties, SDKContext polarisContext, CircuitBreakAPI circuitBreakAPI) {
        return new SuccessCircuitBreakerReporter(properties, polarisContext, circuitBreakAPI);
    }

    @Bean
    @ConditionalOnMissingBean(value={ExceptionCircuitBreakerReporter.class})
    public ExceptionCircuitBreakerReporter exceptionCircuitBreakerReporter(RpcEnhancementReporterProperties properties, SDKContext polarisContext, CircuitBreakAPI circuitBreakAPI) {
        return new ExceptionCircuitBreakerReporter(properties, polarisContext, circuitBreakAPI);
    }

    @Bean
    @ConditionalOnMissingBean(value={ReactiveCircuitBreakerFactory.class})
    public ReactiveCircuitBreakerFactory polarisReactiveCircuitBreakerFactory(CircuitBreakAPI circuitBreakAPI, ConsumerAPI consumerAPI) {
        ReactivePolarisCircuitBreakerFactory factory = new ReactivePolarisCircuitBreakerFactory(circuitBreakAPI, consumerAPI);
        this.customizers.forEach(customizer -> customizer.customize((Object)factory));
        return factory;
    }

    @Bean
    @ConditionalOnBean(value={RpcEnhancementReporterProperties.class})
    @ConditionalOnMissingBean(value={CircuitBreakerConfigModifier.class})
    public CircuitBreakerConfigModifier reactiveCircuitBreakerConfigModifier(RpcEnhancementReporterProperties properties) {
        return new CircuitBreakerConfigModifier(properties);
    }
}

