/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker.gateway;

import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.circuitbreak.client.exception.CallAbortedException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.SpringCloudCircuitBreakerFilterFactory;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.HttpStatusHolder;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.ServiceUnavailableException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PolarisCircuitBreakerFilterFactory
extends SpringCloudCircuitBreakerFilterFactory {
    private String routeIdPrefix;
    private final ReactiveCircuitBreakerFactory reactiveCircuitBreakerFactory;
    private final ObjectProvider<DispatcherHandler> dispatcherHandlerProvider;
    private volatile DispatcherHandler dispatcherHandler;

    public PolarisCircuitBreakerFilterFactory(ReactiveCircuitBreakerFactory reactiveCircuitBreakerFactory, ObjectProvider<DispatcherHandler> dispatcherHandlerProvider, ReactiveDiscoveryClient discoveryClient, DiscoveryLocatorProperties properties) {
        super(reactiveCircuitBreakerFactory, dispatcherHandlerProvider);
        this.reactiveCircuitBreakerFactory = reactiveCircuitBreakerFactory;
        this.dispatcherHandlerProvider = dispatcherHandlerProvider;
        if (discoveryClient != null && properties != null) {
            this.routeIdPrefix = StringUtils.hasText((String)properties.getRouteIdPrefix()) ? properties.getRouteIdPrefix() : discoveryClient.getClass().getSimpleName() + "_";
        }
    }

    private void addExceptionDetails(Throwable t, ServerWebExchange exchange) {
        Optional.ofNullable(t).ifPresent(exception -> exchange.getAttributes().put(ServerWebExchangeUtils.CIRCUITBREAKER_EXECUTION_EXCEPTION_ATTR, exception));
    }

    private DispatcherHandler getDispatcherHandler() {
        if (this.dispatcherHandler == null) {
            this.dispatcherHandler = (DispatcherHandler)this.dispatcherHandlerProvider.getIfAvailable();
        }
        return this.dispatcherHandler;
    }

    private String getCircuitBreakerId(SpringCloudCircuitBreakerFilterFactory.Config config) {
        if (!StringUtils.hasText((String)config.getName()) && StringUtils.hasText((String)config.getRouteId())) {
            if (this.routeIdPrefix != null && config.getRouteId().startsWith(this.routeIdPrefix)) {
                return config.getRouteId().replace(this.routeIdPrefix, "");
            }
            return config.getRouteId();
        }
        return config.getName();
    }

    private boolean isNumeric(String statusString) {
        try {
            Integer.parseInt(statusString);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private List<HttpStatus> getSeriesStatus(String series) {
        if (!Arrays.asList("1**", "2**", "3**", "4**", "5**").contains(series)) {
            throw new InvalidPropertyException(SpringCloudCircuitBreakerFilterFactory.Config.class, "statusCodes", "polaris circuit breaker status code can only be a numeric http status, or a http series pattern, e.g. [\"1**\",\"2**\",\"3**\",\"4**\",\"5**\"]");
        }
        HttpStatus[] allHttpStatus = HttpStatus.values();
        if (series.startsWith("1")) {
            return Arrays.stream(allHttpStatus).filter(HttpStatus::is1xxInformational).collect(Collectors.toList());
        }
        if (series.startsWith("2")) {
            return Arrays.stream(allHttpStatus).filter(HttpStatus::is2xxSuccessful).collect(Collectors.toList());
        }
        if (series.startsWith("3")) {
            return Arrays.stream(allHttpStatus).filter(HttpStatus::is3xxRedirection).collect(Collectors.toList());
        }
        if (series.startsWith("4")) {
            return Arrays.stream(allHttpStatus).filter(HttpStatus::is4xxClientError).collect(Collectors.toList());
        }
        if (series.startsWith("5")) {
            return Arrays.stream(allHttpStatus).filter(HttpStatus::is5xxServerError).collect(Collectors.toList());
        }
        return Arrays.asList(allHttpStatus);
    }

    private Set<HttpStatus> getDefaultStatus() {
        return Arrays.stream(HttpStatus.values()).filter(HttpStatus::is5xxServerError).collect(Collectors.toSet());
    }

    public GatewayFilter apply(final SpringCloudCircuitBreakerFilterFactory.Config config) {
        final Set statuses = config.getStatusCodes().stream().flatMap(statusCode -> {
            ArrayList<HttpStatus> httpStatuses = new ArrayList<HttpStatus>();
            if (this.isNumeric((String)statusCode)) {
                httpStatuses.add(HttpStatusHolder.parse((String)statusCode).getHttpStatus());
            } else {
                httpStatuses.addAll(this.getSeriesStatus((String)statusCode));
            }
            return httpStatuses.stream();
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(statuses)) {
            statuses.addAll(this.getDefaultStatus());
        }
        final String circuitBreakerId = this.getCircuitBreakerId(config);
        return new GatewayFilter(){

            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
                String serviceName = circuitBreakerId;
                if (route != null) {
                    serviceName = route.getUri().getHost();
                }
                String path = exchange.getRequest().getPath().value();
                ReactiveCircuitBreaker cb = PolarisCircuitBreakerFilterFactory.this.reactiveCircuitBreakerFactory.create(serviceName + "#" + path);
                return cb.run(chain.filter(exchange).doOnSuccess(v -> {
                    HashSet<HttpStatus> statusNeedToCheck = new HashSet<HttpStatus>();
                    statusNeedToCheck.addAll(statuses);
                    statusNeedToCheck.addAll(PolarisCircuitBreakerFilterFactory.this.getDefaultStatus());
                    HttpStatusCode status = exchange.getResponse().getStatusCode();
                    if (statusNeedToCheck.contains(HttpStatus.resolve((int)status.value()))) {
                        throw new SpringCloudCircuitBreakerFilterFactory.CircuitBreakerStatusCodeException((SpringCloudCircuitBreakerFilterFactory)PolarisCircuitBreakerFilterFactory.this, status);
                    }
                }), t -> {
                    HttpStatusCode status;
                    if (t instanceof SpringCloudCircuitBreakerFilterFactory.CircuitBreakerStatusCodeException && !statuses.contains(HttpStatus.resolve((int)(status = ((SpringCloudCircuitBreakerFilterFactory.CircuitBreakerStatusCodeException)t).getStatusCode()).value()))) {
                        return Mono.error((Throwable)t);
                    }
                    if (config.getFallbackUri() == null) {
                        CircuitBreakerStatus.FallbackInfo fallbackInfo;
                        if (t instanceof CallAbortedException && (fallbackInfo = ((CallAbortedException)((Object)t)).getFallbackInfo()) != null) {
                            ServerHttpResponse response = exchange.getResponse();
                            response.setRawStatusCode(Integer.valueOf(fallbackInfo.getCode()));
                            if (fallbackInfo.getHeaders() != null) {
                                fallbackInfo.getHeaders().forEach((k, v) -> response.getHeaders().add(k, v));
                            }
                            DataBuffer bodyBuffer = null;
                            if (fallbackInfo.getBody() != null) {
                                byte[] bytes = fallbackInfo.getBody().getBytes(StandardCharsets.UTF_8);
                                bodyBuffer = response.bufferFactory().wrap(bytes);
                            }
                            return bodyBuffer != null ? response.writeWith((Publisher)Flux.just(bodyBuffer)) : response.setComplete();
                        }
                        return Mono.error((Throwable)t);
                    }
                    exchange.getResponse().setStatusCode(null);
                    ServerWebExchangeUtils.reset((ServerWebExchange)exchange);
                    URI uri = exchange.getRequest().getURI();
                    boolean encoded = ServerWebExchangeUtils.containsEncodedParts((URI)uri);
                    URI requestUrl = UriComponentsBuilder.fromUri((URI)uri).host(null).port(null).uri(config.getFallbackUri()).scheme(null).build(encoded).toUri();
                    exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, requestUrl);
                    PolarisCircuitBreakerFilterFactory.this.addExceptionDetails((Throwable)t, exchange);
                    ServerWebExchangeUtils.reset((ServerWebExchange)exchange);
                    ServerHttpRequest request = exchange.getRequest().mutate().uri(requestUrl).build();
                    return PolarisCircuitBreakerFilterFactory.this.getDispatcherHandler().handle(exchange.mutate().request(request).build());
                }).onErrorResume(t -> PolarisCircuitBreakerFilterFactory.this.handleErrorWithoutFallback((Throwable)t, config.isResumeWithoutError()));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator((Object)((Object)PolarisCircuitBreakerFilterFactory.this)).append("name", (Object)config.getName()).append("fallback", (Object)config.getFallbackUri()).toString();
            }
        };
    }

    protected Mono<Void> handleErrorWithoutFallback(Throwable t, boolean resumeWithoutError) {
        if (t instanceof TimeoutException) {
            return Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.GATEWAY_TIMEOUT, t.getMessage(), t));
        }
        if (t instanceof CallAbortedException) {
            return Mono.error((Throwable)new ServiceUnavailableException());
        }
        if (t instanceof SpringCloudCircuitBreakerFilterFactory.CircuitBreakerStatusCodeException) {
            return Mono.empty();
        }
        if (resumeWithoutError) {
            return Mono.empty();
        }
        return Mono.error((Throwable)t);
    }
}

