/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker.reactor;

import com.tencent.cloud.polaris.circuitbreaker.reactor.PolarisCircuitBreakerReactorSubscriber;
import com.tencent.polaris.circuitbreak.api.InvokeHandler;
import com.tencent.polaris.circuitbreak.client.exception.CallAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.Operators;

public class PolarisCircuitBreakerFluxOperator<T>
extends FluxOperator<T, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisCircuitBreakerFluxOperator.class);
    private final InvokeHandler invokeHandler;

    protected PolarisCircuitBreakerFluxOperator(Flux<? extends T> source, InvokeHandler invokeHandler) {
        super(source);
        this.invokeHandler = invokeHandler;
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        try {
            this.invokeHandler.acquirePermission();
            this.source.subscribe(new PolarisCircuitBreakerReactorSubscriber<T>(this.invokeHandler, actual, false));
        }
        catch (CallAbortedException e) {
            LOGGER.debug("ReactivePolarisCircuitBreaker CallAbortedException: {}", (Object)e.getMessage());
            Operators.error(actual, (Throwable)e);
        }
    }
}

