/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker.reactor;

import com.tencent.polaris.circuitbreak.api.InvokeHandler;
import com.tencent.polaris.circuitbreak.api.pojo.InvokeContext;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.util.context.Context;

public class PolarisCircuitBreakerReactorSubscriber<T>
extends BaseSubscriber<T> {
    private final InvokeHandler invokeHandler;
    private final CoreSubscriber<? super T> downstreamSubscriber;
    private final long startTimeMilli;
    private final boolean singleProducer;
    private final AtomicBoolean successSignaled = new AtomicBoolean(false);
    private final AtomicBoolean eventWasEmitted = new AtomicBoolean(false);

    public PolarisCircuitBreakerReactorSubscriber(InvokeHandler invokeHandler, CoreSubscriber<? super T> downstreamSubscriber, boolean singleProducer) {
        this.invokeHandler = invokeHandler;
        this.downstreamSubscriber = downstreamSubscriber;
        this.singleProducer = singleProducer;
        this.startTimeMilli = System.currentTimeMillis();
    }

    public Context currentContext() {
        return this.downstreamSubscriber.currentContext();
    }

    protected void hookOnSubscribe(Subscription subscription) {
        this.downstreamSubscriber.onSubscribe((Subscription)this);
    }

    protected void hookOnNext(T value) {
        if (!this.isDisposed()) {
            if (this.singleProducer && this.successSignaled.compareAndSet(false, true)) {
                long delay = System.currentTimeMillis() - this.startTimeMilli;
                InvokeContext.ResponseContext responseContext = new InvokeContext.ResponseContext();
                responseContext.setDuration(delay);
                responseContext.setDurationUnit(TimeUnit.MILLISECONDS);
                responseContext.setResult(value);
                this.invokeHandler.onSuccess(responseContext);
            }
            this.eventWasEmitted.set(true);
            this.downstreamSubscriber.onNext(value);
        }
    }

    protected void hookOnComplete() {
        if (this.successSignaled.compareAndSet(false, true)) {
            long delay = System.currentTimeMillis() - this.startTimeMilli;
            InvokeContext.ResponseContext responseContext = new InvokeContext.ResponseContext();
            responseContext.setDuration(delay);
            responseContext.setDurationUnit(TimeUnit.MILLISECONDS);
            this.invokeHandler.onSuccess(responseContext);
        }
        this.downstreamSubscriber.onComplete();
    }

    public void hookOnCancel() {
        if (!this.successSignaled.get() && this.eventWasEmitted.get()) {
            long delay = System.currentTimeMillis() - this.startTimeMilli;
            InvokeContext.ResponseContext responseContext = new InvokeContext.ResponseContext();
            responseContext.setDuration(delay);
            responseContext.setDurationUnit(TimeUnit.MILLISECONDS);
            this.invokeHandler.onSuccess(responseContext);
        }
    }

    protected void hookOnError(Throwable e) {
        long delay = System.currentTimeMillis() - this.startTimeMilli;
        InvokeContext.ResponseContext responseContext = new InvokeContext.ResponseContext();
        responseContext.setDuration(delay);
        responseContext.setDurationUnit(TimeUnit.MILLISECONDS);
        responseContext.setError(e);
        this.invokeHandler.onError(responseContext);
        this.downstreamSubscriber.onError(e);
    }
}

