/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker.reporter;

import com.tencent.cloud.rpc.enhancement.AbstractPolarisReporterAdapter;
import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementReporterProperties;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPlugin;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedPluginType;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedRequestContext;
import com.tencent.cloud.rpc.enhancement.plugin.EnhancedResponseContext;
import com.tencent.cloud.rpc.enhancement.plugin.reporter.SuccessPolarisReporter;
import com.tencent.polaris.api.plugin.circuitbreaker.ResourceStat;
import com.tencent.polaris.circuitbreak.api.CircuitBreakAPI;
import com.tencent.polaris.client.api.SDKContext;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;

public class SuccessCircuitBreakerReporter
extends AbstractPolarisReporterAdapter
implements EnhancedPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SuccessPolarisReporter.class);
    private final CircuitBreakAPI circuitBreakAPI;

    public SuccessCircuitBreakerReporter(RpcEnhancementReporterProperties reportProperties, SDKContext context, CircuitBreakAPI circuitBreakAPI) {
        super(reportProperties, context);
        this.circuitBreakAPI = circuitBreakAPI;
    }

    public String getName() {
        return SuccessCircuitBreakerReporter.class.getName();
    }

    public EnhancedPluginType getType() {
        return EnhancedPluginType.POST;
    }

    public void run(EnhancedPluginContext context) throws Throwable {
        if (!this.reportProperties.isEnabled()) {
            return;
        }
        EnhancedRequestContext request = context.getRequest();
        EnhancedResponseContext response = context.getResponse();
        ServiceInstance serviceInstance = Optional.ofNullable(context.getServiceInstance()).orElse((ServiceInstance)new DefaultServiceInstance());
        ResourceStat resourceStat = this.createInstanceResourceStat(serviceInstance.getServiceId(), serviceInstance.getHost(), serviceInstance.getPort(), request.getUrl(), response.getHttpStatus(), context.getDelay(), null);
        LOG.debug("Will report CircuitBreaker ResourceStat of {}. Request=[{} {}]. Response=[{}]. Delay=[{}]ms.", new Object[]{resourceStat.getRetStatus().name(), request.getHttpMethod().name(), request.getUrl().getPath(), response.getHttpStatus(), context.getDelay()});
        this.circuitBreakAPI.report(resourceStat);
    }

    public void handlerThrowable(EnhancedPluginContext context, Throwable throwable) {
        LOG.error("SuccessCircuitBreakerReporter runs failed. context=[{}].", (Object)context, (Object)throwable);
    }

    public int getOrder() {
        return -2147483646;
    }
}

