/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker.resttemplate;

import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.AbstractClientHttpResponse;

public class PolarisCircuitBreakerHttpResponse
extends AbstractClientHttpResponse {
    private final CircuitBreakerStatus.FallbackInfo fallbackInfo;
    private HttpHeaders headers = new HttpHeaders();
    private InputStream body;

    public PolarisCircuitBreakerHttpResponse(int code) {
        this(new CircuitBreakerStatus.FallbackInfo(code, null, null));
    }

    public PolarisCircuitBreakerHttpResponse(int code, String body) {
        this(new CircuitBreakerStatus.FallbackInfo(code, null, body));
    }

    public PolarisCircuitBreakerHttpResponse(int code, Map<String, String> headers, String body) {
        this(new CircuitBreakerStatus.FallbackInfo(code, headers, body));
    }

    PolarisCircuitBreakerHttpResponse(CircuitBreakerStatus.FallbackInfo fallbackInfo) {
        this.fallbackInfo = fallbackInfo;
        if (fallbackInfo.getHeaders() != null) {
            fallbackInfo.getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)this.headers).add(arg_0, arg_1));
        }
        if (fallbackInfo.getBody() != null) {
            this.body = new ByteArrayInputStream(fallbackInfo.getBody().getBytes());
        }
    }

    public final int getRawStatusCode() {
        return this.fallbackInfo.getCode();
    }

    public final String getStatusText() {
        HttpStatus status = HttpStatus.resolve((int)this.getRawStatusCode());
        return status != null ? status.getReasonPhrase() : "";
    }

    public final void close() {
        if (this.body != null) {
            try {
                this.body.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final InputStream getBody() {
        return this.body;
    }

    public final HttpHeaders getHeaders() {
        return this.headers;
    }

    public CircuitBreakerStatus.FallbackInfo getFallbackInfo() {
        return this.fallbackInfo;
    }
}

