/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker.resttemplate;

import com.tencent.cloud.polaris.circuitbreaker.resttemplate.PolarisCircuitBreaker;
import com.tencent.cloud.polaris.circuitbreaker.resttemplate.PolarisCircuitBreakerFallback;
import com.tencent.cloud.polaris.circuitbreaker.resttemplate.PolarisCircuitBreakerRestTemplateInterceptor;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class PolarisCircuitBreakerRestTemplateBeanPostProcessor
implements MergedBeanDefinitionPostProcessor {
    private final ApplicationContext applicationContext;
    private final ConcurrentHashMap<String, PolarisCircuitBreaker> cache = new ConcurrentHashMap();

    public PolarisCircuitBreakerRestTemplateBeanPostProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private void checkPolarisCircuitBreakerRestTemplate(PolarisCircuitBreaker polarisCircuitBreaker) {
        if (StringUtils.hasText((String)polarisCircuitBreaker.fallback()) && !PolarisCircuitBreakerFallback.class.toGenericString().equals(polarisCircuitBreaker.fallbackClass().toGenericString())) {
            throw new IllegalArgumentException("PolarisCircuitBreaker's fallback and fallbackClass could not set at sametime !");
        }
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        if (this.checkAnnotated(beanDefinition, beanType, beanName)) {
            PolarisCircuitBreaker polarisCircuitBreaker = beanDefinition.getSource() instanceof StandardMethodMetadata ? ((StandardMethodMetadata)beanDefinition.getSource()).getIntrospectedMethod().getAnnotation(PolarisCircuitBreaker.class) : beanDefinition.getResolvedFactoryMethod().getAnnotation(PolarisCircuitBreaker.class);
            this.checkPolarisCircuitBreakerRestTemplate(polarisCircuitBreaker);
            this.cache.put(beanName, polarisCircuitBreaker);
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.cache.containsKey(beanName)) {
            StringBuilder interceptorBeanNamePrefix = new StringBuilder();
            PolarisCircuitBreaker polarisCircuitBreaker = this.cache.get(beanName);
            interceptorBeanNamePrefix.append(StringUtils.uncapitalize((String)PolarisCircuitBreaker.class.getSimpleName())).append("_").append(polarisCircuitBreaker.fallback()).append("_").append(polarisCircuitBreaker.fallbackClass().getSimpleName());
            RestTemplate restTemplate = (RestTemplate)bean;
            String interceptorBeanName = interceptorBeanNamePrefix + "@" + bean;
            CircuitBreakerFactory circuitBreakerFactory = (CircuitBreakerFactory)this.applicationContext.getBean(CircuitBreakerFactory.class);
            this.registerBean(interceptorBeanName, polarisCircuitBreaker, this.applicationContext, circuitBreakerFactory, restTemplate);
            PolarisCircuitBreakerRestTemplateInterceptor polarisCircuitBreakerRestTemplateInterceptor = (PolarisCircuitBreakerRestTemplateInterceptor)this.applicationContext.getBean(interceptorBeanName, PolarisCircuitBreakerRestTemplateInterceptor.class);
            restTemplate.getInterceptors().add(0, polarisCircuitBreakerRestTemplateInterceptor);
        }
        return bean;
    }

    private boolean checkAnnotated(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        return beanName != null && beanType == RestTemplate.class && beanDefinition.getSource() instanceof MethodMetadata && ((MethodMetadata)beanDefinition.getSource()).isAnnotated(PolarisCircuitBreaker.class.getName());
    }

    private void registerBean(String interceptorBeanName, PolarisCircuitBreaker polarisCircuitBreaker, ApplicationContext applicationContext, CircuitBreakerFactory circuitBreakerFactory, RestTemplate restTemplate) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(PolarisCircuitBreakerRestTemplateInterceptor.class);
        beanDefinitionBuilder.addConstructorArgValue((Object)polarisCircuitBreaker);
        beanDefinitionBuilder.addConstructorArgValue((Object)applicationContext);
        beanDefinitionBuilder.addConstructorArgValue((Object)circuitBreakerFactory);
        beanDefinitionBuilder.addConstructorArgValue((Object)restTemplate);
        AbstractBeanDefinition interceptorBeanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanFactory.registerBeanDefinition(interceptorBeanName, (BeanDefinition)interceptorBeanDefinition);
    }
}

