/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker.resttemplate;

import com.tencent.cloud.polaris.circuitbreaker.exception.FallbackWrapperException;
import com.tencent.cloud.polaris.circuitbreaker.resttemplate.PolarisCircuitBreaker;
import com.tencent.cloud.polaris.circuitbreaker.resttemplate.PolarisCircuitBreakerFallback;
import com.tencent.cloud.polaris.circuitbreaker.resttemplate.PolarisCircuitBreakerHttpResponse;
import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.circuitbreak.client.exception.CallAbortedException;
import java.io.IOException;
import java.lang.reflect.Method;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class PolarisCircuitBreakerRestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private final PolarisCircuitBreaker polarisCircuitBreaker;
    private final ApplicationContext applicationContext;
    private final CircuitBreakerFactory circuitBreakerFactory;
    private final RestTemplate restTemplate;

    public PolarisCircuitBreakerRestTemplateInterceptor(PolarisCircuitBreaker polarisCircuitBreaker, ApplicationContext applicationContext, CircuitBreakerFactory circuitBreakerFactory, RestTemplate restTemplate) {
        this.polarisCircuitBreaker = polarisCircuitBreaker;
        this.applicationContext = applicationContext;
        this.circuitBreakerFactory = circuitBreakerFactory;
        this.restTemplate = restTemplate;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        try {
            return (ClientHttpResponse)this.circuitBreakerFactory.create(request.getURI().getHost() + "#" + request.getURI().getPath()).run(() -> {
                try {
                    ClientHttpResponse response = execution.execute(request, body);
                    ResponseErrorHandler errorHandler = this.restTemplate.getErrorHandler();
                    if (errorHandler.hasError(response)) {
                        errorHandler.handleError(request.getURI(), request.getMethod(), response);
                    }
                    return response;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }, t -> {
                CircuitBreakerStatus.FallbackInfo fallbackInfo;
                if (StringUtils.hasText((String)this.polarisCircuitBreaker.fallback())) {
                    CircuitBreakerStatus.FallbackInfo fallbackInfo2 = new CircuitBreakerStatus.FallbackInfo(200, null, this.polarisCircuitBreaker.fallback());
                    return new PolarisCircuitBreakerHttpResponse(fallbackInfo2);
                }
                if (!PolarisCircuitBreakerFallback.class.toGenericString().equals(this.polarisCircuitBreaker.fallbackClass().toGenericString())) {
                    Method method = ReflectionUtils.findMethod(PolarisCircuitBreakerFallback.class, (String)"fallback");
                    PolarisCircuitBreakerFallback polarisCircuitBreakerFallback = (PolarisCircuitBreakerFallback)this.applicationContext.getBean(this.polarisCircuitBreaker.fallbackClass());
                    return (PolarisCircuitBreakerHttpResponse)((Object)((Object)ReflectionUtils.invokeMethod((Method)method, (Object)polarisCircuitBreakerFallback)));
                }
                if (t instanceof CallAbortedException && (fallbackInfo = ((CallAbortedException)t).getFallbackInfo()) != null) {
                    return new PolarisCircuitBreakerHttpResponse(fallbackInfo);
                }
                throw new FallbackWrapperException((Throwable)t);
            });
        }
        catch (FallbackWrapperException e) {
            Throwable underlyingException = e.getCause();
            if (underlyingException instanceof RuntimeException) {
                throw (RuntimeException)underlyingException;
            }
            throw new IllegalStateException(underlyingException);
        }
    }
}

