/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.circuitbreaker.util;

import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.polaris.circuitbreaker.common.PolarisCircuitBreakerConfigBuilder;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.Service;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.circuitbreak.client.exception.CallAbortedException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class PolarisCircuitBreakerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PolarisCircuitBreakerUtils.class);

    private PolarisCircuitBreakerUtils() {
    }

    public static String[] resolveCircuitBreakerId(String id) {
        Assert.hasText((String)id, (String)"A CircuitBreaker must have an id. Id could be : namespace#service#method or service#method or service");
        String[] polarisCircuitBreakerMetaData = id.split("#");
        if (polarisCircuitBreakerMetaData.length == 2) {
            return new String[]{MetadataContext.LOCAL_NAMESPACE, polarisCircuitBreakerMetaData[0], polarisCircuitBreakerMetaData[1]};
        }
        if (polarisCircuitBreakerMetaData.length == 3) {
            return new String[]{polarisCircuitBreakerMetaData[0], polarisCircuitBreakerMetaData[1], polarisCircuitBreakerMetaData[2]};
        }
        return new String[]{MetadataContext.LOCAL_NAMESPACE, id, ""};
    }

    public static void reportStatus(ConsumerAPI consumerAPI, PolarisCircuitBreakerConfigBuilder.PolarisCircuitBreakerConfiguration conf, CallAbortedException e) {
        try {
            ServiceCallResult result = new ServiceCallResult();
            result.setMethod(conf.getMethod());
            result.setNamespace(conf.getNamespace());
            result.setService(conf.getService());
            result.setRuleName(e.getRuleName());
            result.setRetStatus(RetStatus.RetReject);
            result.setCallerService((Service)new ServiceKey(conf.getSourceNamespace(), conf.getSourceService()));
            if (Objects.nonNull(e.getFallbackInfo())) {
                result.setRetCode(e.getFallbackInfo().getCode());
            }
            consumerAPI.updateServiceCallResult(result);
        }
        catch (Throwable ex) {
            LOG.error("[CircuitBreaker] report circuitbreaker call result fail ", ex);
        }
    }
}

