/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.adapter;

import com.tencent.polaris.configuration.api.core.ConfigKVFile;
import java.util.Map;
import org.springframework.core.env.MapPropertySource;

public class PolarisPropertySource
extends MapPropertySource {
    private final String namespace;
    private final String group;
    private final String fileName;
    private final ConfigKVFile configKVFile;

    public PolarisPropertySource(String namespace, String group, String fileName, ConfigKVFile configKVFile, Map<String, Object> source) {
        super(namespace + "-" + group + "-" + fileName, source);
        this.namespace = namespace;
        this.group = group;
        this.fileName = fileName;
        this.configKVFile = configKVFile;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getGroup() {
        return this.group;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPropertySourceName() {
        return this.namespace + "-" + this.group + "-" + this.fileName;
    }

    ConfigKVFile getConfigKVFile() {
        return this.configKVFile;
    }

    public String toString() {
        return "PolarisPropertySource{namespace='" + this.namespace + "', group='" + this.group + "', fileName='" + this.fileName + "'}";
    }
}

