/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.adapter;

import com.tencent.cloud.polaris.config.adapter.PolarisConfigPropertyAutoRefresher;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySourceManager;
import com.tencent.cloud.polaris.config.config.PolarisConfigProperties;
import com.tencent.cloud.polaris.config.spring.property.PlaceholderHelper;
import com.tencent.cloud.polaris.config.spring.property.SpringValue;
import com.tencent.cloud.polaris.config.spring.property.SpringValueRegistry;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.NonNull;

public class PolarisRefreshAffectedContextRefresher
extends PolarisConfigPropertyAutoRefresher
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisRefreshAffectedContextRefresher.class);
    private final SpringValueRegistry springValueRegistry;
    private final PlaceholderHelper placeholderHelper;
    private ConfigurableApplicationContext context;
    private ConfigurableBeanFactory beanFactory;
    private TypeConverter typeConverter;

    public PolarisRefreshAffectedContextRefresher(PolarisConfigProperties polarisConfigProperties, PolarisPropertySourceManager polarisPropertySourceManager, SpringValueRegistry springValueRegistry, PlaceholderHelper placeholderHelper) {
        super(polarisConfigProperties, polarisPropertySourceManager);
        this.springValueRegistry = springValueRegistry;
        this.placeholderHelper = placeholderHelper;
    }

    @Override
    public void refreshSpringValue(String changedKey) {
        Collection<SpringValue> targetValues = this.springValueRegistry.get((BeanFactory)this.beanFactory, changedKey);
        if (targetValues == null || targetValues.isEmpty()) {
            return;
        }
        for (SpringValue val : targetValues) {
            this.updateSpringValue(val);
        }
    }

    @Override
    public void refreshConfigurationProperties(Set<String> changeKeys) {
        this.context.publishEvent((ApplicationEvent)new EnvironmentChangeEvent((Object)this.context, changeKeys));
    }

    private void updateSpringValue(SpringValue springValue) {
        try {
            Object value = this.resolvePropertyValue(springValue);
            springValue.update(value);
            LOGGER.info("[SCT Config] Auto update polaris changed value successfully, new value: {}, {}", value, (Object)springValue);
        }
        catch (Throwable ex) {
            LOGGER.error("[SCT Config] Auto update polaris changed value failed, {}", (Object)springValue.toString(), (Object)ex);
        }
    }

    private Object resolvePropertyValue(SpringValue springValue) {
        Object value = this.placeholderHelper.resolvePropertyValue(this.beanFactory, springValue.getBeanName(), springValue.getPlaceholder());
        value = springValue.isField() ? this.typeConverter.convertIfNecessary(value, springValue.getTargetType(), springValue.getField()) : this.typeConverter.convertIfNecessary(value, springValue.getTargetType(), springValue.getMethodParameter());
        return value;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.context = (ConfigurableApplicationContext)applicationContext;
        this.beanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        this.typeConverter = this.beanFactory.getTypeConverter();
    }
}

