/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.configdata;

import com.tencent.cloud.polaris.config.adapter.PolarisConfigFilePuller;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySourceManager;
import com.tencent.cloud.polaris.config.config.ConfigFileGroup;
import com.tencent.cloud.polaris.config.config.PolarisConfigProperties;
import com.tencent.cloud.polaris.config.configdata.PolarisConfigDataResource;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.factory.ConfigFileServiceFactory;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PolarisConfigDataLoader
implements ConfigDataLoader<PolarisConfigDataResource> {
    static final AtomicBoolean INTERNAL_CONFIG_FILES_LOADED = new AtomicBoolean(false);
    static final AtomicBoolean CUSTOM_POLARIS_CONFIG_FILE_LOADED = new AtomicBoolean(false);
    private static final String POLARIS_CONFIG_PROPERTY_SOURCE_NAME = "polaris-config";
    private final Log log;
    private ConfigFileService configFileService;
    private PolarisConfigFilePuller puller;

    public PolarisConfigDataLoader(DeferredLogFactory logFactory) {
        this.log = logFactory.getLog(this.getClass());
    }

    public ConfigData load(ConfigDataLoaderContext context, PolarisConfigDataResource resource) throws ConfigDataResourceNotFoundException {
        try {
            return this.load(context.getBootstrapContext(), resource);
        }
        catch (Exception e) {
            this.log.warn((Object)("Error getting properties from polaris: " + resource), (Throwable)e);
            if (!resource.isOptional()) {
                throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
            }
            return null;
        }
    }

    public ConfigData load(ConfigurableBootstrapContext bootstrapContext, PolarisConfigDataResource resource) {
        CompositePropertySource compositePropertySource = this.locate(bootstrapContext, resource);
        return new ConfigData(compositePropertySource.getPropertySources(), this.getOptions(resource));
    }

    private CompositePropertySource locate(ConfigurableBootstrapContext bootstrapContext, PolarisConfigDataResource resource) {
        PolarisConfigProperties polarisConfigProperties;
        CompositePropertySource compositePropertySource = new CompositePropertySource(POLARIS_CONFIG_PROPERTY_SOURCE_NAME);
        SDKContext sdkContext = (SDKContext)bootstrapContext.get(SDKContext.class);
        if (null == this.configFileService) {
            this.configFileService = ConfigFileServiceFactory.createConfigFileService((SDKContext)sdkContext);
        }
        if (null == this.puller) {
            this.puller = PolarisConfigFilePuller.get(resource.getPolarisContextProperties(), this.configFileService, (PolarisPropertySourceManager)bootstrapContext.get(PolarisPropertySourceManager.class));
        }
        Profiles profiles = resource.getProfiles();
        if (INTERNAL_CONFIG_FILES_LOADED.compareAndSet(false, true)) {
            this.log.info((Object)"loading internal config files");
            String[] activeProfiles = profiles.getActive().toArray(new String[0]);
            String[] defaultProfiles = profiles.getDefault().toArray(new String[0]);
            this.puller.initInternalConfigFiles(compositePropertySource, activeProfiles, defaultProfiles, resource.getServiceName());
        }
        if (!CollectionUtils.isEmpty((polarisConfigProperties = resource.getPolarisConfigProperties()).getGroups()) && CUSTOM_POLARIS_CONFIG_FILE_LOADED.compareAndSet(false, true)) {
            this.log.info((Object)"loading custom config files");
            this.puller.initCustomPolarisConfigFiles(compositePropertySource, polarisConfigProperties.getGroups());
        }
        if (StringUtils.hasText((String)resource.getFileName())) {
            this.log.info((Object)("loading config data config file, group:" + resource.getGroupName() + " file: " + resource.getFileName()));
            this.puller.initCustomPolarisConfigFile(compositePropertySource, this.configFileGroup(resource));
        }
        return compositePropertySource;
    }

    private ConfigData.Option[] getOptions(PolarisConfigDataResource resource) {
        ArrayList<ConfigData.Option> options = new ArrayList<ConfigData.Option>();
        options.add(ConfigData.Option.IGNORE_IMPORTS);
        options.add(ConfigData.Option.IGNORE_PROFILES);
        PolarisConfigProperties polarisConfigProperties = resource.getPolarisConfigProperties();
        if (polarisConfigProperties.isPreference()) {
            options.add(ConfigData.Option.PROFILE_SPECIFIC);
        }
        return options.toArray(new ConfigData.Option[0]);
    }

    private ConfigFileGroup configFileGroup(PolarisConfigDataResource polarisConfigDataResource) {
        String fileName = polarisConfigDataResource.getFileName();
        String groupName = polarisConfigDataResource.getGroupName();
        ConfigFileGroup configFileGroup = new ConfigFileGroup();
        configFileGroup.setName(groupName);
        ArrayList<String> files = new ArrayList<String>();
        files.add(fileName);
        configFileGroup.setFiles(files);
        return configFileGroup;
    }
}

