/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.configdata;

import com.tencent.cloud.polaris.config.ConfigurationModifier;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySourceManager;
import com.tencent.cloud.polaris.config.config.PolarisConfigProperties;
import com.tencent.cloud.polaris.config.configdata.PolarisConfigDataResource;
import com.tencent.cloud.polaris.context.ModifyAddress;
import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.api.SDKContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.Ordered;

public class PolarisConfigDataLocationResolver
implements ConfigDataLocationResolver<PolarisConfigDataResource>,
Ordered {
    public static final String PREFIX = "polaris";
    public static final String POLARIS_PREFIX = "spring.cloud.polaris";
    public static final String COLON = ":";
    public static final String EMPTY_STRING = "";
    private final Log log;

    public PolarisConfigDataLocationResolver(DeferredLogFactory logFactory) {
        this.log = logFactory.getLog(this.getClass());
    }

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        if (!location.hasPrefix(PREFIX)) {
            return false;
        }
        return (Boolean)context.getBinder().bind("spring.cloud.polaris.config.enabled", Boolean.class).orElse((Object)true);
    }

    public List<PolarisConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        return Collections.emptyList();
    }

    public List<PolarisConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        PolarisContextProperties polarisContextProperties;
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        PolarisConfigProperties polarisConfigProperties = this.loadPolarisConfigProperties(resolverContext, PolarisConfigProperties.class, "spring.cloud.polaris.config");
        if (Objects.isNull(polarisConfigProperties)) {
            polarisConfigProperties = new PolarisConfigProperties();
        }
        if (Objects.isNull(polarisContextProperties = this.loadPolarisConfigProperties(resolverContext, PolarisContextProperties.class, POLARIS_PREFIX))) {
            polarisContextProperties = new PolarisContextProperties();
        }
        this.prepareAndInitEarlierPolarisSdkContext(resolverContext, polarisConfigProperties, polarisContextProperties);
        bootstrapContext.registerIfAbsent(PolarisConfigProperties.class, BootstrapRegistry.InstanceSupplier.of((Object)polarisConfigProperties));
        bootstrapContext.registerIfAbsent(PolarisContextProperties.class, BootstrapRegistry.InstanceSupplier.of((Object)polarisContextProperties));
        bootstrapContext.registerIfAbsent(PolarisPropertySourceManager.class, BootstrapRegistry.InstanceSupplier.of((Object)new PolarisPropertySourceManager()));
        bootstrapContext.addCloseListener(event -> {
            ((SDKContext)event.getBootstrapContext().get(SDKContext.class)).destroy();
            PolarisPropertySourceManager polarisPropertySourceManager = (PolarisPropertySourceManager)event.getBootstrapContext().get(PolarisPropertySourceManager.class);
            event.getApplicationContext().getBeanFactory().registerSingleton("polarisPropertySourceManager", (Object)polarisPropertySourceManager);
        });
        return this.loadConfigDataResources(resolverContext, location, profiles, polarisConfigProperties, polarisContextProperties);
    }

    public int getOrder() {
        return -1;
    }

    protected <T> T loadPolarisConfigProperties(ConfigDataLocationResolverContext context, Class<T> typeClass, String prefix) {
        Binder binder = context.getBinder();
        BindHandler bindHandler = this.getBindHandler(context);
        Object instance = !this.registerNotNecessary(typeClass) && context.getBootstrapContext().isRegistered(typeClass) ? context.getBootstrapContext().get(typeClass) : binder.bind(prefix, Bindable.of(typeClass), bindHandler).map(properties -> binder.bind(prefix, Bindable.ofInstance((Object)properties), bindHandler).orElse(properties)).orElseGet(() -> binder.bind(prefix, Bindable.of((Class)typeClass), bindHandler).orElseGet(() -> null));
        return (T)instance;
    }

    private BindHandler getBindHandler(ConfigDataLocationResolverContext context) {
        return (BindHandler)context.getBootstrapContext().getOrElse(BindHandler.class, null);
    }

    private List<PolarisConfigDataResource> loadConfigDataResources(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles, PolarisConfigProperties polarisConfigProperties, PolarisContextProperties polarisContextProperties) {
        String fileName;
        String groupName;
        ArrayList<PolarisConfigDataResource> result = new ArrayList<PolarisConfigDataResource>();
        boolean optional = location.isOptional();
        String groupFileName = this.getRealGroupFileName(location);
        String serviceName = this.loadPolarisConfigProperties(resolverContext, String.class, "spring.application.name");
        if (StringUtils.isBlank((String)serviceName)) {
            serviceName = "application";
            this.log.warn((Object)"No spring.application.name found, defaulting to 'application'");
        }
        String string = groupName = StringUtils.isBlank((String)groupFileName) ? EMPTY_STRING : this.parseGroupName(groupFileName, serviceName);
        if (StringUtils.isNotBlank((String)groupName)) {
            this.log.info((Object)("group from configDataLocation is " + groupName));
        }
        String string2 = fileName = StringUtils.isBlank((String)groupFileName) ? EMPTY_STRING : this.parseFileName(groupFileName);
        if (StringUtils.isNotBlank((String)fileName)) {
            this.log.info((Object)("file from configDataLocation is " + fileName));
        }
        PolarisConfigDataResource polarisConfigDataResource = new PolarisConfigDataResource(polarisConfigProperties, polarisContextProperties, profiles, optional, fileName, groupName, serviceName);
        result.add(polarisConfigDataResource);
        return result;
    }

    private String getRealGroupFileName(ConfigDataLocation location) {
        String prefixedValue = location.getNonPrefixedValue(PREFIX);
        if (StringUtils.isBlank((String)prefixedValue) || !prefixedValue.startsWith(COLON)) {
            return prefixedValue;
        }
        return prefixedValue.substring(1);
    }

    private String parseFileName(String groupFileName) {
        String[] split = groupFileName.split(COLON);
        if (split.length > 1) {
            return split[1];
        }
        return split[0];
    }

    private String parseGroupName(String groupFileName, String serviceName) {
        String[] split = groupFileName.split(COLON);
        if (split.length > 1) {
            return split[0];
        }
        return serviceName;
    }

    private void prepareAndInitEarlierPolarisSdkContext(ConfigDataLocationResolverContext resolverContext, PolarisConfigProperties polarisConfigProperties, PolarisContextProperties polarisContextProperties) {
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        if (!bootstrapContext.isRegistered(SDKContext.class)) {
            SDKContext sdkContext = this.sdkContext(resolverContext, polarisConfigProperties, polarisContextProperties);
            sdkContext.init();
            bootstrapContext.register(SDKContext.class, BootstrapRegistry.InstanceSupplier.of((Object)sdkContext));
        }
    }

    private SDKContext sdkContext(ConfigDataLocationResolverContext resolverContext, PolarisConfigProperties polarisConfigProperties, PolarisContextProperties polarisContextProperties) {
        List<PolarisConfigModifier> modifierList = this.modifierList(polarisConfigProperties, polarisContextProperties);
        return SDKContext.initContextByConfig((Configuration)polarisContextProperties.configuration(modifierList, () -> this.loadPolarisConfigProperties(resolverContext, String.class, "spring.cloud.client.ip-address"), () -> this.loadPolarisConfigProperties(resolverContext, Integer.class, "spring.cloud.polaris.local-port")));
    }

    private List<PolarisConfigModifier> modifierList(PolarisConfigProperties polarisConfigProperties, PolarisContextProperties polarisContextProperties) {
        ArrayList<PolarisConfigModifier> modifierList = new ArrayList<PolarisConfigModifier>();
        ModifyAddress modifyAddress = new ModifyAddress(polarisContextProperties);
        ConfigurationModifier configurationModifier = new ConfigurationModifier(polarisConfigProperties, polarisContextProperties);
        modifierList.add((PolarisConfigModifier)modifyAddress);
        modifierList.add(configurationModifier);
        return modifierList;
    }

    private boolean registerNotNecessary(Class<?> typeClass) {
        return typeClass.isPrimitive() || Number.class.isAssignableFrom(typeClass) || String.class.isAssignableFrom(typeClass) || Character.class.isAssignableFrom(typeClass) || Boolean.class.isAssignableFrom(typeClass);
    }
}

