/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.listener;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tencent.cloud.polaris.config.listener.ConfigChangeEvent;
import com.tencent.cloud.polaris.config.listener.ConfigChangeListener;
import com.tencent.polaris.configuration.api.core.ChangeType;
import com.tencent.polaris.configuration.api.core.ConfigPropertyChangeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public final class PolarisConfigListenerContext {
    private static final Logger LOG = LoggerFactory.getLogger(PolarisConfigListenerContext.class);
    private static final AtomicReference<ExecutorService> EAR = new AtomicReference();
    private static final List<ConfigChangeListener> listeners = Lists.newCopyOnWriteArrayList();
    private static final Map<ConfigChangeListener, Set<String>> interestedKeys = Maps.newHashMap();
    private static final Map<ConfigChangeListener, Set<String>> interestedKeyPrefixes = Maps.newHashMap();
    private static final Cache<String, Object> properties = CacheBuilder.newBuilder().build();

    private PolarisConfigListenerContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExecutorService executor() {
        if (EAR.get() != null) return EAR.get();
        Class<PolarisConfigListenerContext> clazz = PolarisConfigListenerContext.class;
        synchronized (PolarisConfigListenerContext.class) {
            int coreThreadSize = Runtime.getRuntime().availableProcessors();
            ThreadPoolExecutor service = new ThreadPoolExecutor(coreThreadSize, coreThreadSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(64), (ThreadFactory)new CustomizableThreadFactory("Config-Change-Notify-Thread-Pool-"));
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    LOG.info("Shutting down config change notify thread pool");
                    service.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
            EAR.set(service);
            // ** MonitorExit[var0] (shouldn't be in output)
            return EAR.get();
        }
    }

    static void initialize(Map<String, Object> ret) {
        properties.putAll(ret);
    }

    static Map<String, ConfigPropertyChangeInfo> merge(Map<String, Object> ret) {
        HashMap changes = Maps.newHashMap();
        if (!ret.isEmpty()) {
            HashMap origin = Maps.newHashMap((Map)properties.asMap());
            HashMap deleted = Maps.newHashMap();
            origin.keySet().parallelStream().forEach(key -> {
                if (!ret.containsKey(key)) {
                    deleted.put(key, new ConfigPropertyChangeInfo(key, String.valueOf(origin.get(key)), null, ChangeType.DELETED));
                    properties.invalidate(key);
                }
            });
            changes.putAll(deleted);
            ret.keySet().parallelStream().forEach(key -> {
                Object oldValue = properties.getIfPresent(key);
                Object newValue = ret.get(key);
                if (oldValue != null) {
                    if (!newValue.equals(oldValue)) {
                        properties.put(key, newValue);
                        changes.put(key, new ConfigPropertyChangeInfo(key, String.valueOf(oldValue), String.valueOf(newValue), ChangeType.MODIFIED));
                    }
                } else {
                    properties.put(key, newValue);
                    changes.put(key, new ConfigPropertyChangeInfo(key, null, String.valueOf(newValue), ChangeType.ADDED));
                }
            });
        }
        return changes;
    }

    public static void addChangeListener(@NonNull ConfigChangeListener listener, @Nullable Set<String> interestedKeys, @Nullable Set<String> interestedKeyPrefixes) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
            PolarisConfigListenerContext.interestedKeys.put(listener, (Set<String>)(interestedKeys == null ? Sets.newHashSet() : interestedKeys));
            PolarisConfigListenerContext.interestedKeyPrefixes.put(listener, (Set<String>)(interestedKeyPrefixes == null ? Sets.newHashSet() : interestedKeyPrefixes));
        }
    }

    public static void fireConfigChange(Set<String> changedKeys, Map<String, ConfigPropertyChangeInfo> changes) {
        List<ConfigChangeListener> listeners = PolarisConfigListenerContext.findMatchedConfigChangeListeners(changedKeys);
        for (ConfigChangeListener listener : listeners) {
            Set<String> interestedChangedKeys = PolarisConfigListenerContext.resolveInterestedChangedKeys(listener, changedKeys);
            HashMap<String, ConfigPropertyChangeInfo> modifiedChanges = new HashMap<String, ConfigPropertyChangeInfo>(interestedChangedKeys.size());
            interestedChangedKeys.parallelStream().forEach(key -> modifiedChanges.put((String)key, (ConfigPropertyChangeInfo)changes.get(key)));
            ConfigChangeEvent event = new ConfigChangeEvent(modifiedChanges, interestedChangedKeys);
            PolarisConfigListenerContext.executor().execute(() -> listener.onChange(event));
        }
    }

    private static List<ConfigChangeListener> findMatchedConfigChangeListeners(Set<String> changedKeys) {
        ArrayList configChangeListeners = Lists.newArrayList();
        for (ConfigChangeListener listener : listeners) {
            if (!PolarisConfigListenerContext.isConfigChangeListenerInterested(listener, changedKeys)) continue;
            configChangeListeners.add(listener);
        }
        return configChangeListeners;
    }

    private static boolean isConfigChangeListenerInterested(ConfigChangeListener listener, Set<String> changedKeys) {
        Set<String> interestedKeys = PolarisConfigListenerContext.interestedKeys.get(listener);
        Set<String> interestedKeyPrefixes = PolarisConfigListenerContext.interestedKeyPrefixes.get(listener);
        if ((interestedKeys == null || interestedKeys.isEmpty()) && (interestedKeyPrefixes == null || interestedKeyPrefixes.isEmpty())) {
            return true;
        }
        if (interestedKeys != null) {
            for (String interestedKey : interestedKeys) {
                if (!changedKeys.contains(interestedKey)) continue;
                return true;
            }
        }
        if (interestedKeyPrefixes != null) {
            for (String prefix : interestedKeyPrefixes) {
                for (String changedKey : changedKeys) {
                    if (!changedKey.startsWith(prefix)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static Set<String> resolveInterestedChangedKeys(ConfigChangeListener listener, Set<String> changedKeys) {
        HashSet interestedChangedKeys = Sets.newHashSet();
        if (interestedKeys.containsKey(listener)) {
            Set<String> interestedKeys = PolarisConfigListenerContext.interestedKeys.get(listener);
            for (String interestedKey : interestedKeys) {
                if (!changedKeys.contains(interestedKey)) continue;
                interestedChangedKeys.add(interestedKey);
            }
        }
        if (interestedKeyPrefixes.containsKey(listener)) {
            Set<String> interestedKeyPrefixes = PolarisConfigListenerContext.interestedKeyPrefixes.get(listener);
            for (String interestedKeyPrefix : interestedKeyPrefixes) {
                for (String changedKey : changedKeys) {
                    if (!changedKey.startsWith(interestedKeyPrefix)) continue;
                    interestedChangedKeys.add(changedKey);
                }
            }
        }
        return Collections.unmodifiableSet(interestedChangedKeys);
    }
}

