/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.spring.property;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.tencent.cloud.polaris.config.spring.property.SpringValue;
import com.tencent.polaris.client.util.NamedThreadFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;

public class SpringValueRegistry
implements DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SpringValueRegistry.class);
    private static final long CLEAN_INTERVAL_IN_SECONDS = 5L;
    private final Map<BeanFactory, Multimap<String, SpringValue>> registry = Maps.newConcurrentMap();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Object LOCK = new Object();
    private ScheduledExecutorService executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(BeanFactory beanFactory, String key, SpringValue springValue) {
        if (!this.registry.containsKey(beanFactory)) {
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.registry.containsKey(beanFactory)) {
                    this.registry.put(beanFactory, (Multimap<String, SpringValue>)Multimaps.synchronizedListMultimap((ListMultimap)LinkedListMultimap.create()));
                }
            }
        }
        this.registry.get(beanFactory).put((Object)key, (Object)springValue);
        if (this.initialized.compareAndSet(false, true)) {
            this.initialize();
        }
    }

    public Collection<SpringValue> get(BeanFactory beanFactory, String key) {
        Multimap<String, SpringValue> beanFactorySpringValues = this.registry.get(beanFactory);
        if (beanFactorySpringValues == null) {
            return null;
        }
        return beanFactorySpringValues.get((Object)key);
    }

    private void initialize() {
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("polaris-spring-value-registry"));
        this.executor.scheduleAtFixedRate(() -> {
            try {
                this.scanAndClean();
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage(), ex);
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    private void scanAndClean() {
        Iterator<Multimap<String, SpringValue>> iterator = this.registry.values().iterator();
        while (!Thread.currentThread().isInterrupted() && iterator.hasNext()) {
            Multimap<String, SpringValue> springValues = iterator.next();
            springValues.entries().removeIf(springValue -> !((SpringValue)springValue.getValue()).isTargetBeanValid());
        }
    }

    public void destroy() throws Exception {
        this.executor.shutdown();
    }
}

