/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.discovery;

import com.tencent.cloud.common.pojo.PolarisServiceInstance;
import com.tencent.cloud.common.util.DiscoveryUtil;
import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.cloud.polaris.discovery.PolarisDiscoveryHandler;
import com.tencent.cloud.polaris.extend.nacos.NacosContextProperties;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.rpc.InstancesResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.util.CollectionUtils;

public class PolarisServiceDiscovery {
    private final NacosContextProperties nacosContextProperties;
    private final PolarisDiscoveryProperties polarisDiscoveryProperties;
    private final PolarisDiscoveryHandler polarisDiscoveryHandler;

    public PolarisServiceDiscovery(NacosContextProperties nacosContextProperties, PolarisDiscoveryProperties polarisDiscoveryProperties, PolarisDiscoveryHandler polarisDiscoveryHandler) {
        this.nacosContextProperties = nacosContextProperties;
        this.polarisDiscoveryProperties = polarisDiscoveryProperties;
        this.polarisDiscoveryHandler = polarisDiscoveryHandler;
    }

    public List<ServiceInstance> getInstances(String serviceId) throws PolarisException {
        serviceId = DiscoveryUtil.rewriteServiceId((String)serviceId);
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>();
        InstancesResponse filteredInstances = this.polarisDiscoveryHandler.getHealthyInstances(serviceId);
        ServiceInstances serviceInstances = filteredInstances.toServiceInstances();
        for (Instance instance : serviceInstances.getInstances()) {
            instances.add((ServiceInstance)new PolarisServiceInstance(instance));
        }
        return instances;
    }

    public List<String> getServices() throws PolarisException {
        if (CollectionUtils.isEmpty((Collection)this.polarisDiscoveryHandler.getServices().getServices())) {
            return Collections.emptyList();
        }
        return this.polarisDiscoveryHandler.getServices().getServices().stream().map(ServiceInfo::getService).collect(Collectors.toList());
    }
}

