/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.discovery.reactive;

import com.tencent.cloud.polaris.discovery.PolarisServiceDiscovery;
import com.tencent.polaris.api.exception.PolarisException;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class PolarisReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisReactiveDiscoveryClient.class);
    private final PolarisServiceDiscovery polarisServiceDiscovery;

    public PolarisReactiveDiscoveryClient(PolarisServiceDiscovery polarisServiceDiscovery) {
        this.polarisServiceDiscovery = polarisServiceDiscovery;
    }

    public String description() {
        return "Spring Cloud Tencent Polaris Reactive Discovery Client.";
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        return Mono.justOrEmpty((Object)serviceId).flatMapMany(this.loadInstancesFromPolaris()).subscribeOn(Schedulers.boundedElastic());
    }

    private Function<String, Publisher<ServiceInstance>> loadInstancesFromPolaris() {
        return serviceId -> {
            try {
                return Flux.fromIterable(this.polarisServiceDiscovery.getInstances((String)serviceId));
            }
            catch (PolarisException e) {
                LOGGER.error("get service instance[{}] from polaris error!", serviceId, (Object)e);
                return Flux.empty();
            }
        };
    }

    public Flux<String> getServices() {
        return Flux.defer(() -> {
            try {
                return Flux.fromIterable(this.polarisServiceDiscovery.getServices());
            }
            catch (Exception e) {
                LOGGER.error("get services from polaris server fail,", (Throwable)e);
                return Flux.empty();
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }
}

