/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.discovery.refresh;

import com.google.common.collect.Sets;
import com.tencent.polaris.api.plugin.registry.AbstractResourceEventListener;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.client.pojo.ServiceInstancesByProto;
import com.tencent.polaris.client.pojo.ServicesByProto;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.CollectionUtils;

public class PolarisServiceStatusChangeListener
extends AbstractResourceEventListener
implements ApplicationEventPublisherAware {
    public static final AtomicLong INDEX = new AtomicLong(0L);
    private static final Logger LOG = LoggerFactory.getLogger(PolarisServiceStatusChangeListener.class);
    private ApplicationEventPublisher publisher;

    public void onResourceUpdated(ServiceEventKey svcEventKey, RegistryCacheValue oldValue, RegistryCacheValue newValue) {
        if (newValue.getEventType() == ServiceEventKey.EventType.SERVICE) {
            if (oldValue instanceof ServicesByProto && newValue instanceof ServicesByProto) {
                LOG.debug("receive service={} change event", (Object)svcEventKey);
                Set oldServiceInfoSet = ((ServicesByProto)oldValue).getServices().stream().map(i -> i.getNamespace() + "::" + i.getService()).collect(Collectors.toSet());
                Set newServiceInfoSet = ((ServicesByProto)newValue).getServices().stream().map(i -> i.getNamespace() + "::" + i.getService()).collect(Collectors.toSet());
                Sets.SetView addServiceInfoSetView = Sets.difference(newServiceInfoSet, oldServiceInfoSet);
                Sets.SetView deleteServiceInfoSetView = Sets.difference(oldServiceInfoSet, newServiceInfoSet);
                if (addServiceInfoSetView.isEmpty() && deleteServiceInfoSetView.isEmpty()) {
                    return;
                }
                LOG.info("Service status is update. Add service of {}. Delete service of {}", (Object)addServiceInfoSetView, (Object)deleteServiceInfoSetView);
                this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)INDEX.getAndIncrement()));
            }
        } else if (newValue.getEventType() == ServiceEventKey.EventType.INSTANCE && oldValue instanceof ServiceInstancesByProto && newValue instanceof ServiceInstancesByProto) {
            LOG.debug("receive service instances={} change event", (Object)svcEventKey);
            ServiceInstancesByProto oldIns = (ServiceInstancesByProto)oldValue;
            ServiceInstancesByProto newIns = (ServiceInstancesByProto)newValue;
            if (CollectionUtils.isEmpty((Collection)oldIns.getInstances()) && !CollectionUtils.isEmpty((Collection)newIns.getInstances()) || !CollectionUtils.isEmpty((Collection)oldIns.getInstances()) && CollectionUtils.isEmpty((Collection)newIns.getInstances())) {
                LOG.info("Service status of {} is update.", (Object)newIns.getService());
                this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)INDEX.getAndIncrement()));
            }
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }
}

