/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.endpoint;

import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.cloud.polaris.discovery.PolarisDiscoveryHandler;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.rpc.InstancesResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.cloud.client.discovery.DiscoveryClient;

@Endpoint(id="polaris-discovery")
public class PolarisDiscoveryEndpoint {
    private final PolarisDiscoveryProperties polarisDiscoveryProperties;
    private final DiscoveryClient polarisDiscoveryClient;
    private final PolarisDiscoveryHandler polarisDiscoveryHandler;

    public PolarisDiscoveryEndpoint(PolarisDiscoveryProperties polarisDiscoveryProperties, DiscoveryClient polarisDiscoveryClient, PolarisDiscoveryHandler polarisDiscoveryHandler) {
        this.polarisDiscoveryProperties = polarisDiscoveryProperties;
        this.polarisDiscoveryClient = polarisDiscoveryClient;
        this.polarisDiscoveryHandler = polarisDiscoveryHandler;
    }

    @ReadOperation
    public Map<String, Object> polarisDiscovery(@Selector String serviceId) {
        HashMap<String, Object> polarisDiscoveryInfo = new HashMap<String, Object>();
        polarisDiscoveryInfo.put("PolarisDiscoveryProperties", this.polarisDiscoveryProperties);
        ArrayList<ServiceInstances> serviceInstancesInfoList = new ArrayList<ServiceInstances>();
        if (StringUtils.isNotEmpty((String)serviceId)) {
            ServiceInstances serviceInstances = this.getServiceInstances(serviceId);
            serviceInstancesInfoList.add(serviceInstances);
            polarisDiscoveryInfo.put("ServiceInstances", serviceInstancesInfoList);
            return polarisDiscoveryInfo;
        }
        for (String service : this.polarisDiscoveryClient.getServices()) {
            ServiceInstances serviceInstances = this.getServiceInstances(service);
            serviceInstancesInfoList.add(serviceInstances);
        }
        polarisDiscoveryInfo.put("ServiceInstances", serviceInstancesInfoList);
        return polarisDiscoveryInfo;
    }

    private ServiceInstances getServiceInstances(String serviceId) {
        InstancesResponse instancesResponse = this.polarisDiscoveryHandler.getHealthyInstances(serviceId);
        return instancesResponse.toServiceInstances();
    }
}

