/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.extend.nacos;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.cloud.polaris.extend.nacos.NacosContextProperties;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.factory.config.consumer.DiscoveryConfigImpl;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import com.tencent.polaris.factory.config.provider.RegisterConfigImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class NacosConfigModifier
implements PolarisConfigModifier {
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String CONTEXT_PATH = "contextPath";
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosConfigModifier.class);
    private static final String ID = "nacos";
    private final NacosContextProperties nacosContextProperties;

    public NacosConfigModifier(NacosContextProperties nacosContextProperties) {
        this.nacosContextProperties = nacosContextProperties;
    }

    public void modify(ConfigurationImpl configuration) {
        if (Objects.isNull(this.nacosContextProperties) || !this.nacosContextProperties.isEnabled()) {
            return;
        }
        boolean nacosAvailable = false;
        try {
            nacosAvailable = null != Class.forName("com.alibaba.nacos.api.naming.NamingService");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!nacosAvailable) {
            LOGGER.error("Please import \"connector-nacos\" dependency when enabling nacos service registration and discovery.\nAdd dependency configuration below to pom.xml:\n<dependency>\n\t<groupId>com.tencent.polaris</groupId>\n\t<artifactId>connector-nacos</artifactId>\n</dependency>");
            throw new RuntimeException("Dependency \"connector-nacos\" not found.");
        }
        if (CollectionUtils.isEmpty((Collection)configuration.getGlobal().getServerConnectors())) {
            configuration.getGlobal().setServerConnectors(new ArrayList());
        }
        if (CollectionUtils.isEmpty((Collection)configuration.getGlobal().getServerConnectors()) && null != configuration.getGlobal().getServerConnector()) {
            configuration.getGlobal().getServerConnectors().add(configuration.getGlobal().getServerConnector());
        }
        ServerConnectorConfigImpl serverConnectorConfig = new ServerConnectorConfigImpl();
        serverConnectorConfig.setId(ID);
        if (StringUtils.isBlank((String)this.nacosContextProperties.getServerAddr())) {
            throw new IllegalArgumentException("nacos server addr must not be empty, please set it byspring.cloud.nacos.discovery.server-addr");
        }
        serverConnectorConfig.setAddresses(Collections.singletonList(this.nacosContextProperties.getServerAddr()));
        serverConnectorConfig.setProtocol(ID);
        Map metadata = serverConnectorConfig.getMetadata();
        if (StringUtils.isNotBlank((String)this.nacosContextProperties.getUsername())) {
            metadata.put(USERNAME, this.nacosContextProperties.getUsername());
        }
        if (StringUtils.isNotBlank((String)this.nacosContextProperties.getPassword())) {
            metadata.put(PASSWORD, this.nacosContextProperties.getPassword());
        }
        if (StringUtils.isNotBlank((String)this.nacosContextProperties.getContextPath())) {
            metadata.put(CONTEXT_PATH, this.nacosContextProperties.getContextPath());
        }
        configuration.getGlobal().getServerConnectors().add(serverConnectorConfig);
        DiscoveryConfigImpl discoveryConfig = new DiscoveryConfigImpl();
        discoveryConfig.setServerConnectorId(ID);
        discoveryConfig.setEnable(Boolean.valueOf(this.nacosContextProperties.isDiscoveryEnabled()));
        configuration.getConsumer().getDiscoveries().add(discoveryConfig);
        RegisterConfigImpl registerConfig = new RegisterConfigImpl();
        registerConfig.setServerConnectorId(ID);
        registerConfig.setEnable(this.nacosContextProperties.isRegisterEnabled());
        configuration.getProvider().getRegisters().add(registerConfig);
    }

    public int getOrder() {
        return ContextConstant.ModifierOrder.LAST;
    }
}

